unit crt2;

{$o+}

interface
uses crt,dos;
var regs:registers;
procedure WriteXY(x, y : integer; s : string);
type dd=-2..255;
procedure frame(a,b,c,d:byte; e:dd);
procedure setcursor(b,e:byte);
procedure print(x,y,count:integer;a:char;attr:byte);
function getscreenchar(x,y:integer):char;
function getscreenattr(x,y:integer):byte;

implementation

procedure WriteXY(x, y : integer; s : string);
begin
  if (x in [1..80]) and (y in [1..25]) then
  begin
    GoToXY(x, y);
    Write(s);
  end
end;

function getscreenchar(x,y:integer):char;
begin
gotoxy(x,y);
regs.bh:=0;
regs.ah:=8;
intr($10,regs);
getscreenchar:=chr(regs.al);
end;

function getscreenattr(x,y:integer):byte;
begin
gotoxy(x,y);
regs.bh:=0;
regs.ah:=8;
intr($10,regs);
getscreenattr:=regs.ah;
end;

procedure print(x,y,count:integer;a:char;attr:byte);
begin
gotoxy(x,y);
regs.ah:=9;
regs.cx:=count;
regs.bh:=0;
regs.al:=ord(a);
regs.bl:=attr;
intr($10,regs);
end;

procedure frame(a,b,c,d:byte; e:dd);
var i:integer;
begin
   if (a in [1..80]) and (c in [1..80]) and (b in [1..25]) and (d in [1..25]) and (e>-3) and (e<256) then
     begin
        case e of                                                                         
          -1: begin writexy(a,b,''); writexy(a,d,''); writexy(c,b,''); writexy(c,d,''); end;
          -2: begin writexy(a,b,''); writexy(a,d,''); writexy(c,b,'');
                    if (c<80) and (d<25) then writexy(c,d,''); end;
        else  begin writexy(a,b,chr(e)); writexy(a,d,chr(e)); writexy(c,b,chr(e)); writexy(c,d,chr(e)); end;
        end;
        for i:=a+1 to c-1 do
        begin
          case e of
           -1: begin writexy(i,b,''); writexy(i,d,''); end;
           -2: begin writexy(i,b,''); writexy(i,d,''); end;
           else begin writexy(i,b,chr(e)); writexy(i,d,chr(e)); end;
          end;
        end;
        for i:=b+1 to d-1 do
        begin
          case e of
           -1: begin writexy(a,i,''); writexy(c,i,''); end;
           -2: begin writexy(a,i,''); writexy(c,i,''); end;
            else begin writexy(a,i,chr(e)); writexy(c,i,chr(e)); end;
          end;
        end;
     end;
 if (c=80) and (d=25) then
 case e of
 -1: print(80,25,1,'',getscreenattr(80,24));
 -2: print(80,25,1,'',getscreenattr(80,24));
 else
 print(80,25,1,chr(e),getscreenattr(80,24));
 end;

end;

procedure setcursor(b,e:byte);
begin
 regs.ah:=1;
 regs.ch:=b;
 regs.dh:=e;
 intr($10,regs);
end;

end.
