unit Figures;
interface
uses
  Dos,crt;
const
  MaxSprites = 4;
  MaxDim =69*56;
  noimage=38;
type
  ScreenTypePointer = ^ScreenType;       { Pointer to a virtual screen  }
  ScreenType = array [1..64000] of byte; { Array to hold virtual screen }
  SpriteType = record
                 oldx, oldy,             { - old location  4 bytes      }
                 x, y : integer;         { - current location 4 bytes   }
                 w, h : byte;            { - width and height 2 bytes   }
                 Buffer : array [0..MaxDim-1] of byte;
               { ^^^^^^----- so, this stores the background }
                 Active : boolean;       { - currently active           }
                 ix, iy : integer;       { - sprite increment           }
                 end;
MyImageType = array [0..MaxDim-1] of byte;
MyImagepointertype=^MyImageType;

PALType = array [0..255] of record
                            R, G, B : byte;
                            end;



var
  PAL : PALType;
  Sprite : array [1..MaxSprites] of SpriteType; { Array of sprites      }
  Virtual_Screen : ScreenTypePointer;    { Pointer to virtual screen    }
  mmyimage : array [0..noimage] of MyImagepointerType;
  i,j:byte;
  right:array[0..noimage] of boolean;

  procedure SetCRTMode (Mode:word);
  procedure ShowVirtualScreen;
  procedure LoadPAL (FileName:string;mix:boolean);
  procedure LoadCEL (FileName:string;ScrPtr:pointer);
  procedure LoadPRF (f:string; xx,yy:word);
  procedure DrawSprite (var Sprite:SpriteType; var image:Myimagetype;condition:byte);
  procedure SaveSpriteBackground (var Sprite : Spritetype);
  procedure RestoreSpriteBackground (var Sprite : Spritetype);
  procedure HideSprites;
  procedure fadeout (down,up:byte);
  procedure fadein (down,up:byte);
  procedure blacken;
  procedure WaitForVerticalRetrace;

  procedure flip(var image: myimagepointertype;w,h:byte);
  procedure FillBox (x1, y1, x2, y2 : integer; b : byte);

implementation

procedure WaitForVerticalRetrace; assembler;
label
  l1, l2;
asm
    cli
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h
    jz  l2
    sti
end;

procedure DrawSprite(var Sprite:SpriteType;var image:Myimagetype; condition:byte); assembler;
label
  _Redraw, _DrawLoop, _Exit, _LineLoop, _NextLine, _Store, _NoPaint, _Black, _Paint, _No;
var
temp:word;
  asm
    push  ds
    push  es
    lds   si,Sprite
    mov   ax,[si+4]     { ax = x }
    mov   bx,[si+6]     { bx = y }
{    cmp   ax,[si]       { if x <> oldx then _Redraw
    jne   _Redraw
    cmp   bx,[si+2]
    je    _Exit         { if (x=oldx) and (y=oldy) then exit }
_Redraw:
    mov   [si],ax       { oldx = x }
    mov   [si+2],bx     { oldy = y }
    push  ax
    push  bx
    mov   ax,word(Virtual_Screen+2)
    mov   es,ax         { ES=A000h }
    pop   bx            { ax = y }
    mov   ax,320
    mul   bx            { ax = y * 320 }
    pop   bx            { ax = x }
    add   ax,bx         { bx = bx + ax dvs. skjermadr.. }
    mov   di,ax         { di = skjermadr. }
    mov   dl,[si+9]     { dl = height of sprite }
    xor   ch,ch
    mov   cl,[si+8]     { cx = width of sprite }
{    add   si,10         { si = start of spritedata }

    lds   si,image      { <----- load my image }
    cld
_DrawLoop:
    push  di            { store y adr. for later }
    push  cx            { store width }
{    mov save,cx}
_LineLoop:
    mov   bl,byte ptr [si]
    or    bl,bl      { Has to paint? }
{    pop si}
    jnz   _Store     { Yes, goto _Store }
_NoPaint:
    inc    si
    inc    di
    loop   _LineLoop
    jmp    _NextLine

_Store:
    cmp condition,1
    jg _Black
_Paint:
    movsb
    loop  _LineLoop
    jmp    _NextLine
_Black:
    push ax
    mov    al,[ds:si]
    xor    ah,ah
    mov    temp,ax
    pop ax
    cmp    temp,33
    jg     _Paint        { Yes, jump to _Paint }

    xor    dh,dh
    mov    [es:di],dh
    mov    dh,[ds:si]
    cmp  condition,2
    je   _No
    add    dh,31         { Point to Blue part of the pal. }
    mov    [es:di],dh
_No:
    inc    si
    inc    di
    loop  _LineLoop

_NextLine:
    pop   cx
    pop   di
    dec   dl
    jz    _Exit
    add   di,320        { di = next line of sprite }
    jmp   _DrawLoop
_Exit:
    pop   es
    pop   ds
  end;

procedure SaveSpriteBackground (var Sprite : Spritetype); assembler;
label
  _Redraw, _DrawLoop, _Exit;
  asm
    push  ds
    push  es
    les   di,Sprite
    mov   ax,es:[di+4]     { ax = x }
    mov   bx,es:[di+6]     { bx = y }
    push  ax
    push  bx
    mov   ax,word(Virtual_Screen+2)
    mov   ds,ax         { DS=A000h }
    pop   bx            { bx = y }
    mov   ax,320
    mul   bx            { ax = y * 320 }
    pop   bx            { bx = x }
    add   ax,bx         { ax = ax + bx dvs. skjermadr.. }
    mov   si,ax         { si = skjermadr. }
    mov   dl,es:[di+9]     { dl = height of sprite }
    xor   ch,ch
    mov   cl,es:[di+8]     { cx = width of sprite }
    add   di,10  { di = start of screenbuffer }              {<--- Changed }
    cld
_DrawLoop:
    push  si            { store y adr. for later }
    push  cx            { store width }
    rep   movsb
    pop   cx
    pop   si
    dec   dl
    jz    _Exit
    add   si,320        { di = next line of sprite }
    jmp   _DrawLoop
_Exit:
    pop   es
    pop   ds
  end;

procedure RestoreSpriteBackground(var Sprite : Spritetype); assembler;
label
  _Redraw, _DrawLoop, _Exit, _LineLoop;
  asm
    push  ds
    push  es
    lds   si,Sprite
    mov   ax,[si]       { ax = x }
    mov   bx,[si+2]     { bx = y }
    push  ax
    push  bx
    mov   ax,word(Virtual_Screen+2)
    mov   es,ax         { ES=A000h }
    pop   bx            { ax = y }
    mov   ax,320
    mul   bx            { ax = y * 320 }
    pop   bx            { ax = x }
    add   ax,bx         { bx = bx + ax dvs. skjermadr.. }
    mov   di,ax         { di = skjermadr. }
    mov   dl,[si+9]     { dl = height of sprite }
    xor   ch,ch
    mov   cl,[si+8]     { cx = width of sprite }
    add   si,10         { si = start of BackGround data }
    cld
_DrawLoop:
    push  di            { store y adr. for later }
    push  cx            { store width }
    rep   movsb
    pop   cx
    pop   di
    dec   dl
    jz    _Exit
    add   di,320        { di = next line of sprite }
    jmp   _DrawLoop
_Exit:
    pop   es
    pop   ds
  end;

procedure HideSprites;
var
  I : byte;
begin
  for I := MaxSprites downto 1 do
    if (Sprite [I].oldx <> -1) then begin
      RestoreSpriteBackground (Sprite [I]);
      Sprite [I].oldx := -1;
    end;
end;

procedure FillBox (x1, y1, x2, y2 : integer; b : byte); assembler;
label
  _l1;
asm
  push  ds
  push  es
  mov   ax,word(Virtual_Screen+2)
  mov   es,ax
  mov   ax,y1
  mov   bx,320
  mul   bx
  mov   di,ax
  add   di,x1
  mov   ax,y1
  mov   dx,y2
  sub   dx,ax
  inc   dx

  mov   ax,x1
  mov   cx,x2
  sub   cx,ax { cx contains number of bytes across }
  inc   cx
  mov   al,b
  cld
_l1:
  push  di
  push  cx
  rep   stosb
  pop   cx
  pop   di
  add   di,320
  dec   dx
  jnz   _l1
  pop   es
  pop   ds
end;



procedure SetCRTMode (Mode : word);
begin
  asm
    mov ax,Mode;
    int 10h
  end;
end;

procedure LoadPAL (FileName : string;mix:boolean);
var
  Fil : file of PALType;
  I : integer;
begin
  assign (Fil, FileName);
  reset (Fil);
  read (Fil, PAL);
  close (Fil);
  if mix then
  for I := 0 to 255 do
  	begin
		Port[$3c8]:=i;
		Port[$3c9]:=PAL[i].R;
		Port[$3c9]:=PAL[i].G;
		Port[$3c9]:=PAL[i].B;
	end;
end;

procedure fadeout(down,up:byte);
begin
for i:=40 downto 1 do
begin
WaitForVerticalRetrace;
for j:=down to up do
	begin

		Port[$3c8]:=j;
		Port[$3c9]:=round(pal[j].R*i/41);
		Port[$3c9]:=round(pal[j].G*i/41);
		Port[$3c9]:=round(pal[j].B*i/41);
	end;
end;
end;

procedure fadein(down,up:byte);
begin
for i:=1 to 40 do
begin
WaitForVerticalRetrace;
for j:=down to up do
	begin
		Port[$3c8]:=j;
		Port[$3c9]:=round(pal[j].R*i/41);
		Port[$3c9]:=round(pal[j].G*i/41);
		Port[$3c9]:=round(pal[j].B*i/41);
	end;
end;
end;


procedure ShowVirtualScreen; assembler;
    asm
      push ds
      push es
      xor  si,si
      xor  di,di
      cld
      mov  ax,word(Virtual_Screen+2)
      mov  ds,ax
      mov  ax,0A000h
      mov  es,ax
      mov  cx,7D00h
      rep  movsw
      pop  es
      pop  ds
    end;

procedure blacken;
var d:byte;
begin
for d:=0 to 255 do
	begin
        Port[$3c8]:=d;
	Port[$3c9]:=0;
	Port[$3c9]:=0;
	Port[$3c9]:=0;
	end;
end;

procedure loadPRF(f:string; xx,yy:word);
var
fff:file;
x,y,w,h:longint;
color,count:byte;
d:word;
p,filea:pointer;
re,size,i,j:word;
fwh:file of longint;

begin
assign(fwh,f);
reset(fwh);
seek(fwh,4);read(fwh,w);read(fwh,h);
close(fwh);

assign(fff,f);
reset(fff,1);
size:=filesize(fff);
mark(p);
new(filea);
getmem(filea,size);
j:=seg(filea^);
blockread(fff,filea^,size,re);
close(fff);
x:=0;y:=h;
i:=16;

while i<(size+8) do
begin
   color:=mem[j:i];   inc(i);
   count:=mem[j:i];   inc(i);
   for d:=1 to count do
   begin
   mem[$a000:x+xx+(y+yy)*320]:=color;
   inc(x);
    if x>w then begin dec(y);x:=0; end;
   end;
end;
release(p);
end;


procedure LoadCEL (FileName :  string; ScrPtr : pointer);
var
  Fil : file;
  Buf : array [1..1024] of byte;
  BlocksRead, Count : word;
begin
  filename:=filename+'.CEL';
  assign (Fil, FileName);
  reset (Fil, 1);
  Count := 0; BlocksRead := $FFFF;
  while (not eof (Fil)) and (BlocksRead <> 0) do
  begin
    BlockRead (Fil, mem[seg(ScrPtr^): ofs(ScrPtr^)+Count], 1024, BlocksRead);
    Count := Count + 1024;
  end;
  close (Fil);
end;

procedure flip(var image: myimagepointertype;w,h:byte);
var
i,j:byte;
temp:byte;
_seg,_ofs:word;
begin
_seg:=seg(image^);
_ofs:=ofs(image^);
for i:= 0 to w div 2  do
for j:= 0 to h do
begin
if mem[_seg:_ofs+i+j*(w+1)]<>mem[_seg:_ofs+(w-i)+j*(w+1)] then
    begin
    temp:=mem[_seg:_ofs+i+j*(w+1)];
    mem[_seg:_ofs+i+j*(w+1)]:=mem[_seg:_ofs+(w-i)+j*(w+1)];
    mem[_seg:_ofs+(w-i)+j*(w+1)]:=temp;
    end;
end;
end;



var
  Dum : ^byte;
begin
  repeat
    new (Virtual_Screen);
    if ofs (Virtual_Screen^) <> 0 then
    begin
      dispose (Virtual_Screen);
      new (Dum);
    end;
  until ofs (Virtual_Screen^) = 0;

for i:= 0 to noimage do
  repeat
    new (mmyimage[i]);
    if (ofs (mmyimage[i]^)<>0)and
    (seg(mmyimage[i]^)=seg(virtual_screen))  then
    begin
      dispose (mmyimage[i]);
      new (Dum);
    end;
  until (ofs(mmyimage[i]^)=0)and(seg(mmyimage[i]^)<>seg(virtual_screen));

end.
