unit graphic;
interface

procedure SetCRTMode(Mode:word);
procedure LoadPAL (FileName : string;mix:boolean);

implementation

type
PALType = array [0..255] of record
                        R, G, B : byte; end;

var pal:paltype;
procedure SetCRTMode(Mode:word); assembler;
asm
mov ax,Mode;
int 10h
end;

procedure LoadPAL (FileName : string;mix:boolean);
var
  Fil : file of PALType;
  I : integer;
begin
  assign (Fil, FileName);
  reset (Fil);
  read (Fil, PAL);
  close (Fil);
  if mix then
  for I := 0 to 255 do
  	begin
		Port[$3c8]:=i;
		Port[$3c9]:=PAL[i].R;
		Port[$3c9]:=PAL[i].G;
		Port[$3c9]:=PAL[i].B;
	end;
end;
end.