unit music;
interface
procedure musicoff;
procedure playmusic(s:string);
procedure playmusicforeground(s:string);
function musicbusy:boolean;
implementation

uses dos;
var
oldint1c,exitsave:pointer;
mstring:string;
mhere,mdelay1,mdelay2,mnotelength,mtempo,moctave,mkind:word;
freq:array[0..83] of word;

function getnumber(min,max,default:word):word;
var n:word;
begin
if (mhere <= length(mstring)) and (mstring[mhere]='=') then
   begin
   while (mhere <= length(mstring)) and ( mstring[mhere]<>';') do inc(mhere);
   if (mhere<= length(mstring)) and (mstring[mhere]=';') then inc(mhere);
   getnumber:=default;
   exit;
   end;
n:=0;
while (mhere<=length(mstring)) and (mstring[mhere] in ['0'..'9']) do
   begin
   n:=n*10+(ord(mstring[mhere])-ord('0'));
   inc(mhere);
   end;
if (n<min) or (n>max) then getnumber:=default else getnumber:=n;
end;

procedure setupdelays;
var
r:real;
begin
r:=getnumber(1,64,mnotelength);
while (mhere<=length(mstring)) and (mstring[mhere]='.') do
    begin
    inc(mhere);r:=r*0.75;
    end;
mdelay1:=round(4368.0/(r*mtempo));
if mkind < 8 then
     mdelay2:=mdelay1*(8-mkind) div 8
else mdelay2:=0;
dec(mdelay1,mdelay2);
end;

procedure musicnext; interrupt;
var
note:word;
ch:char;
begin
inline($9c/$ff/$1e/>oldint1c);
if mdelay1 >0 then
begin
dec(mdelay1);
if mdelay1 >0 then exit;
end;
if mdelay2 >0 then
begin
mdelay1:=mdelay2;
mdelay2:=0;
port[$61]:=port[$61] and $f8;
exit;
end;
if mhere=0 then exit;
if mhere>length(mstring) then
begin
mhere:=0;
port[$61]:=port[$61] and $f8;
exit;
end;
while mhere<=length(mstring) do
begin
ch:=upcase(mstring[mhere]);
inc(mhere);
case ch of
'O':moctave:=getnumber(0,7,4);
'L':mnotelength:=getnumber(0,64,64);
'T':mtempo:=getnumber(32,255,120);
'M':if mhere<=length(mstring) then
    begin ch:=upcase(mstring[mhere]);
    inc(mhere);
    case ch of
    'L':mkind:=8;
    'N':mkind:=7;
    'S':mkind:=6;
    end;
    end;
'P':begin
    port[$61]:=port[$61] and $f8;
    setupdelays;
    exit;
    end;
'A'..'G','>','<':begin
                 note:=moctave*12;
                 if ch='>' then
                 begin if mhere<=length(mstring) then
                       ch:=upcase(mstring[mhere]);
                       inc(mhere);
                       if note<=71 then inc(note,12);
                       end;
                 if ch='<' then
                 begin if mhere<=length(mstring) then
                       ch:=upcase(mstring[mhere]);
                       inc(mhere);
                       if note>=12 then dec(note,12);
                       end;
              case ch of
              'A':inc(note,9);
              'B':inc(note,11);
              'C':inc(note,0);
              'D':inc(note,2);
              'E':inc(note,4);
              'F':inc(note,5);
              'G':inc(note,7);
              end;
           if (mhere<=length(mstring)) and
              ( (mstring[mhere]='#') or (mstring[mhere]='+') ) then
              begin inc(mhere);
                    if note<83 then inc(note); end;
           if (mhere<=length(mstring)) and (mstring[mhere]='-') then
              begin inc(mhere);
                    if note>0 then dec(note); end;
           note:=freq[note];
           port[$61]:=port[$61] and $f8;
           port[$43]:=$b6;
           port[$42]:=lo(note);
           port[$42]:=hi(note);
           port[$61]:=port[$61] or $03;
           setupdelays;
           exit;
           end;
'N':begin note:=getnumber(1,84,0);
          port[$61]:=port[$61] and $f8;
          if note >0 then
          begin
           note:=freq[note-1];
           port[$43]:=$b6;
           port[$42]:=lo(note);
           port[$42]:=hi(note);
           port[$61]:=port[$61] or $03;
          end;
          setupdelays;
          exit;
          end;
'X':begin
    while (mhere<=length(mstring)) and (mstring[mhere]<>';') do inc(mhere);
    if (mhere<=length(mstring)) and (mstring[mhere]=';') then inc(mhere);
    end;
end;
end;
end;

procedure musicoff;
begin
mhere:=0;
mdelay1:=0;
mdelay2:=0;
port[$61]:=port[$61] and $f8;
end;

procedure playmusic(s:string);
begin
musicoff;
mstring:=s;
mnotelength:=4;
mtempo:=120;
moctave:=4;
mkind:=7;
mhere:=1;
end;

procedure playmusicforeground(s:string);
begin
mstring:=s;
playmusic(mstring);
while mhere>0 do;
end;

function musicbusy:boolean;
begin
if mhere>0 then musicbusy:=true else musicbusy:=false;
end;

{$f+}

procedure shutdown;
begin
musicoff;
exitproc:=exitsave;
setintvec($1c,oldint1c);
end;

{$f-}

procedure initialize;
var
i:word;
r1,r2:real;
begin
r1:=1193180.0/8000.0;
r2:=exp(ln(2.0)/12.0);
for i:= 83 downto 0 do
begin
freq[i]:=round(r1);
r1:=r1*r2;
end;
musicoff;
getintvec($1c,oldint1c);
setintvec($1c,@musicnext);
exitsave:=exitproc;
exitproc:=@shutdown;
end;

begin
initialize;
end.