//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "smc.h"
#include "LevelGraphicsEdit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//TLevelGraphicsEditForm *LevelGraphicsEditForm;
//---------------------------------------------------------------------------
__fastcall TLevelGraphicsEditForm::TLevelGraphicsEditForm(TComponent* Owner)
		  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void TLevelGraphicsEditForm::edit_graphics(TSMC* smc_,int wh_,int hh_,int si_,word* block_,byte* tile_,byte r0_,int nt_){
	smc=smc_; wh=wh_; hh=hh_; si=si_; block=block_; tile=tile_; r0=r0_; nt=nt_;
	ix=0; selrow=selcol=0;
	currblock=block;
	ComboBoxBlock->ItemIndex=0;
	DrawGridBlock->Color=clBlack;
	DrawGridBlock->FixedColor=clBlack;
	DrawGridBlock->RowCount=hh;
	DrawGridBlock->ColCount=wh;
	DrawGridTiles->Color=clBlack;
	DrawGridTiles->FixedColor=clBlack;
	DrawGridTiles->RowCount=nt/16;
	LabelPalette->Color=clWhite;
	CheckBoxFlipX->Color=clWhite;
	CheckBoxFlipY->Color=clWhite;
	this->Color=clBlack;
	this->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::FormCreate(TObject *Sender)
{
	for(int i=0;i<256;i++){
		AnsiString s=IntToHex(i,2);
		ComboBoxBlock->Items->Add(s);
	}
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::ComboBoxBlockDrawItem(
		TWinControl *Control, int Index, TRect &Rect, TOwnerDrawState State)
{
	Graphics::TBitmap* item_bitmap=new Graphics::TBitmap;
	item_bitmap->Width=wh*8; item_bitmap->Height=hh*8;
	item_bitmap->Canvas->Brush->Color=(State.Contains(odSelected)?smc->selected_pal:smc->pal)[0];
	item_bitmap->Canvas->FillRect(TRect(0,0,item_bitmap->Width,item_bitmap->Height));
	smc->drawblock(item_bitmap,0,0,Index,wh,hh,si,block,tile,r0,State.Contains(odSelected));
	ComboBoxBlock->Canvas->Draw(Rect.left,Rect.top,item_bitmap);
	delete item_bitmap;
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::DrawGridTilesSelectCell(
		TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
	word &b=*currblock;
	b=(b&~0x3FF)|((ARow*16+ACol)&0x3FF);
	//DrawGridTiles->Invalidate();
	DrawGridBlock->Invalidate();
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::CheckBoxFlipXClick(TObject *Sender)
{
	word &b=*currblock;
	b=(b&~0x4000)|(CheckBoxFlipX->Checked?0x4000:0);
	DrawGridTiles->Invalidate();
	DrawGridBlock->Invalidate();
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::CheckBoxFlipYClick(TObject *Sender)
{
	word &b=*currblock;
	b=(b&~0x8000)|(CheckBoxFlipY->Checked?0x8000:0);
	DrawGridTiles->Invalidate();
	DrawGridBlock->Invalidate();
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::ComboBoxBlockChange(
		TObject *Sender)
{
	ix=ComboBoxBlock->ItemIndex;
	DrawGridBlock->Invalidate();
	TGridRect gr={0,0,0,0};
	DrawGridBlock->Selection=gr;
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::DrawGridBlockDrawCell(
		TObject *Sender, int ACol, int ARow, TRect &Rect,
		TGridDrawState State)
{
	Graphics::TBitmap* room_bitmap=new Graphics::TBitmap;
	room_bitmap->Width=8; room_bitmap->Height=8;
	room_bitmap->Canvas->Brush->Color=(State.Contains(gdSelected)?smc->selected_pal:smc->pal)[r0];
	room_bitmap->Canvas->FillRect(TRect(0,0,room_bitmap->Width,room_bitmap->Height));
	smc->drawtile(room_bitmap,0,0,block[ix*wh*hh+ARow*wh+ACol],si,tile,r0,State.Contains(gdSelected));
	DrawGridBlock->Canvas->StretchDraw(Rect,room_bitmap);
	delete room_bitmap;
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::DrawGridTilesDrawCell(
		TObject *Sender, int ACol, int ARow, TRect &Rect,
		TGridDrawState State)
{
	word t0=(CheckBoxFlipX->Checked?0x4000:0)|(CheckBoxFlipY->Checked?0x8000:0)|((UpDownPalIndex->Position&7)<<10);
	Graphics::TBitmap* room_bitmap=new Graphics::TBitmap;
	room_bitmap->Width=8; room_bitmap->Height=8;
	room_bitmap->Canvas->Brush->Color=(State.Contains(gdSelected)?smc->selected_pal:smc->pal)[r0];
	room_bitmap->Canvas->FillRect(TRect(0,0,room_bitmap->Width,room_bitmap->Height));
	smc->drawtile(room_bitmap,0,0,t0+ARow*16+ACol,si,tile,r0,State.Contains(gdSelected));
	DrawGridTiles->Canvas->StretchDraw(Rect,room_bitmap);
	delete room_bitmap;
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::DrawGridBlockSelectCell(
		TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
	selrow=ARow; selcol=ACol;
	currblock=&(block[ix*wh*hh+ARow*wh+ACol]);
	word dt=*currblock;
	int ti=dt&0x3FF;
	int r=dt>>10&7;
	bool fx=dt&0x4000,fy=dt&0x8000;
	DrawGridTiles->Row=ti>>4;
	DrawGridTiles->Col=ti&15;
	CheckBoxFlipX->Checked=fx;
	CheckBoxFlipY->Checked=fy;
	UpDownPalIndex->Position=r;
	DrawGridTiles->Invalidate();
}
//---------------------------------------------------------------------------
void __fastcall TLevelGraphicsEditForm::UpDownPalIndexClick(
		TObject *Sender, TUDBtnType Button)
{
	word &b=*currblock;
	b=(b&~0x1C00)|((UpDownPalIndex->Position&7)<<10);
	DrawGridTiles->Invalidate();
	DrawGridBlock->Invalidate();
}
//---------------------------------------------------------------------------
