//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "smc.h"
#include "Main.h"
#include "Hacks.h"
#include "Select.h"
//#include "LevelGraphicsEdit.h"
//#include <Clipbrd.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
		  : TForm(Owner)
{
	room_clipboard_notempty = false;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::Open1Click(TObject *Sender)
{
	if(OpenDialogSMC->Execute()){
//		int lv;
/*		AnsiString s=InputBox("Szint","Szint","0");
		try{level=StrToInt(s);}catch(...){level=0;}*/
		open_file(/*file*/OpenDialogSMC->FileName);
	}
}
//---------------------------------------------------------------------------

void TMainForm::open_file(AnsiString filename){
  OpenDialogSMC->FileName = filename;
  bool oldopen=is_open;
  is_open=false;
  int nlevel=Select(level_names,COUNT(level_names),-1,"Select level");
  if(nlevel<0||nlevel>26){ is_open=oldopen; return; }
  // First ask level, then try to open file.
  if(!smc.opensmc(filename)) { /*is_open=true;*/ ShowMessage("Can't open file \""+filename+"\"."); return; }
  room_clipboard_notempty = false;
  smc.openlevel(nlevel);
  //smc.open_level_graphics(smc.level_type=*((char*)smc.ms_smc->Memory+0x36EE+SMCHD+level));
  //smc.object_level_type=*((char*)smc.ms_smc->Memory+0xED08+SMCHD+level);
  smc.curr_room=smc.level.start_room;
  if (nlevel == 20) smc.curr_room = 0; // Jaffar's level
  is_open=true;
  room_bitmap->Width=240;
  room_bitmap->Height=192;
  DrawRoom();
  //PaintBox1->Invalidate();
  //PaintBox1Paint(NULL);
  ComboBoxTile->Enabled=true;
  ComboBoxBack->Enabled=true;
  Level1->Enabled=true;
  PaintBox1->Enabled=true;
  Guards1->Enabled=true;
  Graphics1->Enabled=true;
  EditAnimGroup->Enabled=true;
  ComboBoxFg->Enabled=true;
  ComboBoxGg->Enabled=true;
  ComboBoxOb->Enabled=true;
  CheckListBoxFlags->Enabled=true;
  ComboBoxMod->Enabled=true;
  EditRm->Enabled=true;
  EditPs->Enabled=true;
  CheckBoxNx->Enabled=true;
  Room1->Enabled=true;
  FFilename=filename;
  Caption=FFilename;
  if (this->Showing) {
    this->FocusControl(NULL); // to accept keys
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormCreate(TObject *Sender)
{
	auto_mode=true; scale=1;
	room_bitmap=new Graphics::TBitmap;
	room_bitmap->Width=240;
	room_bitmap->Height=192;
	Level1->Enabled=false;
	Guards1->Enabled=false;
	Graphics1->Enabled=false;
	Room1->Enabled=false;
	AnsiString s; int i;
	for(i=0;i<256;i++){
		s=IntToHex(i,2);
		ComboBoxTile->Items->Add(s);
		ComboBoxBack->Items->Add(s);
		ComboBoxFg->Items->Add(s);
		ComboBoxGg->Items->Add(s);
		ComboBoxMod->Items->Add(s);
	}
	for(i=0;i<COUNT(object_names);i++){
		ComboBoxOb->Items->Add(object_names[i]);
	}
	for(i=0;i<14;i++){
		sidebtn[i]=new TButton(Application);
		sidebtn[i]->Parent=this;
		sidebtn[i]->Tag=i;
		sidebtn[i]->OnClick=SideClick;
	}
	is_open=false;
	Automatic1Click(Sender);
	PlaceSidebtn();
	if(ParamCount()>=1){
		open_file(ParamStr(1));
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormDestroy(TObject *Sender)
{
	delete room_bitmap;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PaintBox1Paint(TObject *Sender)
{
	PaintBox1->Width=room_bitmap->Width*scale;
	PaintBox1->Height=room_bitmap->Height*scale;
	if(scale==1){
		PaintBox1->Canvas->Draw(0,0,room_bitmap);
	}else{
		PaintBox1->Canvas->StretchDraw(TRect(0,0,PaintBox1->Width,PaintBox1->Height),room_bitmap);
	}
}
//---------------------------------------------------------------------------

void TMainForm::GotoAdjacentRoom(int direction) {
  int new_room = smc.level.room_links[smc.curr_room][direction];
  if (new_room <= 23) {
    smc.curr_room = new_room;
    smc.clear_selection();
    DrawRoom();
  }
}

void __fastcall TMainForm::ButtonLeftClick(TObject *Sender)
{
  GotoAdjacentRoom(0);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonRightClick(TObject *Sender)
{
  GotoAdjacentRoom(1);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonUpClick(TObject *Sender)
{
  GotoAdjacentRoom(2);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonDownClick(TObject *Sender)
{
  GotoAdjacentRoom(3);
}
//---------------------------------------------------------------------------
void TMainForm::DrawRoom(){
	// Draw the room itself.
	smc.drawroom(room_bitmap);
	PaintBox1->OnPaint(NULL);

	/*
	ButtonLeft->Enabled = smc.level.room_links[smc.curr_room][0]<24;
	ButtonRight->Enabled = smc.level.room_links[smc.curr_room][1]<24;
	ButtonUp->Enabled = smc.level.room_links[smc.curr_room][2]<24;
	ButtonDown->Enabled = smc.level.room_links[smc.curr_room][3]<24;
	ButtonLeft->Caption = smc.level.room_links[smc.curr_room][0];
	ButtonRight->Caption = smc.level.room_links[smc.curr_room][1];
	ButtonUp->Caption = smc.level.room_links[smc.curr_room][2];
	ButtonDown->Caption = smc.level.room_links[smc.curr_room][3];
	*/
	// Display adjacent rooms on the buttons.
	TButton* link_buttons[4] = {ButtonLeft, ButtonRight, ButtonUp, ButtonDown};
	for (int i=0; i<4; i++) {
		int room = smc.level.room_links[smc.curr_room][i];
		link_buttons[i]->Enabled = room<24;
		link_buttons[i]->Caption = IntToStr(room);
	}
	
	AnsiString s;
	s.printf("%s, room %d, tile %d", level_names[smc.curr_level], smc.curr_room, last_clicked_row*10+last_clicked_column);
	StatusBar1->SimpleText=s;
}
//---------------------------------------------------------------------------


void __fastcall TMainForm::PaintBox1MouseDown(TObject *Sender,
		TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if(!is_open) return;
	int row=Y/(64*scale),column=X/(24*scale);
	last_clicked_row=row; last_clicked_column=column;
	if(Shift.Contains(ssCtrl)){
		// Toggle selection of the clicked tile.
		smc.sel[row][column]^=true;
	}else{
		// Select the clicked tile only.
		smc.clear_selection();
		smc.sel[row][column]=true;
	}

	int background = smc.level.background[smc.curr_room][row][column];
        GetBackTile(background);
        /*
	ComboBoxBack->ItemIndex = background;
	EditAnimGroup->Text = IntToStr(smc.get_back_anim(background));
        */

	//ComboBoxTile->ItemIndex = smc.level.foreground[smc.curr_room][row][column];
	GetTile(smc.level.foreground[smc.curr_room][row][column]);
	/*ComboBoxFg->ItemIndex = smc.level.block_fg[smc.level.foreground[smc.curr_room][row][column]];
	ComboBoxGg->ItemIndex = smc.level.block_gg[smc.level.foreground[smc.curr_room][row][column]];
	ComboBoxOb->ItemIndex = smc.level.block_object[smc.level.foreground[smc.curr_room][row][column]];*/

	//ComboBoxMod->ItemIndex = smc.level.modifiers[smc.curr_room][row][column];
	GetMod(smc.level.modifiers[smc.curr_room][row][column]);

	DrawRoom();
        this->FocusControl(NULL); // to accept keys
}

void SetFlags(TCheckListBox* CheckListBox, int flags){
	for (int i = 0; i < CheckListBox->Items->Count; i++) {
		CheckListBox->Checked[i] = (flags >> i) & 1;
	}
}

int GetFlags(TCheckListBox* CheckListBox){
        int flags;
	for (int i = 0; i < CheckListBox->Items->Count; i++) {
		if (CheckListBox->Checked[i]) flags |= 1 << i;
	}
        return flags;
}

void TMainForm::GetTile(int index){
	ComboBoxTile->ItemIndex = index;
	ComboBoxFg->ItemIndex = smc.level.block_fg[index];
	ComboBoxGg->ItemIndex = smc.level.block_gg[index];
	ComboBoxOb->ItemIndex = smc.level.block_object[index];
	//byte flags = smc.level.block_flags_back_anim[index];
	byte flags = smc.get_block_flags(index);
        SetFlags(CheckListBoxFlags, flags);
        ShowHideDoorEvents();
}

void TMainForm::GetBackTile(int index){
  ComboBoxBack->ItemIndex = index;
  EditAnimGroup->Text = IntToStr(smc.get_back_anim(index));
}

void TMainForm::ReloadCurrentTile(){
  int all = -2;
  // -2: none, -1: different values, 0..255: a single value
  for(int i=0;i<3;i++) for(int j=0;j<10;j++) if(smc.sel[i][j])
  {
    int current = smc.level.foreground[smc.curr_room][i][j];
    if (all == -2) all = current;
    if (all >= 0 && all != current) all = -1;
  }
  if (all < -1) all = -1;
  ComboBoxTile->ItemIndex = all;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxTileDrawItem(TWinControl *Control,
		int Index, TRect &Rect, TOwnerDrawState State)
{
	if(!is_open) return;
	bool sel=State.Contains(odSelected);
	Graphics::TBitmap* item_bitmap = new Graphics::TBitmap;
	item_bitmap->Width=48; item_bitmap->Height=64;
	item_bitmap->Canvas->Brush->Color=smc.pal[0];
	item_bitmap->Canvas->FillRect(TRect(0,0,48,64));
	smc.drawblock(item_bitmap,0,0,smc.level.block_fg[Index],6,8,32,smc.fgblock,smc.fgtile,0x60,sel);
	smc.draw_object(item_bitmap,0,0,smc.level.block_object[Index],sel);
	smc.drawblock(item_bitmap,0,0,smc.level.block_gg[Index],3,8,32,smc.ggblock,smc.ggtile,0x20,sel);
	item_bitmap->Canvas->Brush->Color=clWhite;
	item_bitmap->Canvas->Pen->Color=clBlack;
	if(smc.show_labels){
		int x=smc.level.block_object[Index];
		if(x>0&&x<COUNT(object_names)) item_bitmap->Canvas->TextOutA(0,0,object_names[x]);
	}
        if (smc.show_floors_walls) {
                smc.draw_floor_wall(item_bitmap,0,0,smc.get_block_flags(Index));
        }
	ComboBoxTile->Canvas->Draw(Rect.left,Rect.top,item_bitmap);
	ComboBoxTile->Canvas->TextOutA(48+Rect.left,Rect.top,IntToHex(Index,2));
	delete item_bitmap;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxTileChange(TObject *Sender)
{
	if(!is_open) return;
	for(int i=0;i<3;i++) for(int j=0;j<10;j++) if(smc.sel[i][j]) smc.level.foreground[smc.curr_room][i][j]=ComboBoxTile->ItemIndex;
	GetTile(ComboBoxTile->ItemIndex);
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxBackChange(TObject *Sender)
{
	if(!is_open) return;
	for(int i=0;i<3;i++) for(int j=0;j<10;j++) if(smc.sel[i][j]) smc.level.background[smc.curr_room][i][j]=ComboBoxBack->ItemIndex;
        GetBackTile(ComboBoxBack->ItemIndex);
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxBackDrawItem(TWinControl *Control,
		int Index, TRect &Rect, TOwnerDrawState State)
{
	if(!is_open) return;
	Graphics::TBitmap* item_bitmap=new Graphics::TBitmap;
	item_bitmap->Width=24; item_bitmap->Height=64;
	item_bitmap->Canvas->Brush->Color=smc.pal[0];
	item_bitmap->Canvas->FillRect(TRect(0,0,24,64));
	smc.drawblock(item_bitmap,0,0,Index,3,8,16,smc.bgblock,smc.bgtile,0x00,State.Contains(odSelected));
	ComboBoxBack->Canvas->Draw(Rect.left,Rect.top,item_bitmap);
	ComboBoxBack->Canvas->TextOutA(24+Rect.left,Rect.top,IntToHex(Index,2));
	delete item_bitmap;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Save1Click(TObject *Sender)
{
	if(!is_open) return;
	smc.savelevel();
	smc.saveenv();
	smc.savesmc(FFilename);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxFgDrawItem(TWinControl *Control, int Index,
		TRect &Rect, TOwnerDrawState State)
{
	if(!is_open) return;
	Graphics::TBitmap* item_bitmap=new Graphics::TBitmap;
	item_bitmap->Width=48; item_bitmap->Height=64;
	item_bitmap->Canvas->Brush->Color=smc.pal[0];
	item_bitmap->Canvas->FillRect(TRect(0,0,48,64));
	smc.drawblock(item_bitmap,0,0,Index,6,8,32,smc.fgblock,smc.fgtile,0x60,State.Contains(odSelected));
	ComboBoxFg->Canvas->Draw(Rect.left,Rect.top,item_bitmap);
	ComboBoxFg->Canvas->TextOutA(48+Rect.left,Rect.top,IntToHex(Index,2));
	delete item_bitmap;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxGgDrawItem(TWinControl *Control, int Index,
		TRect &Rect, TOwnerDrawState State)
{
	if(!is_open) return;
	Graphics::TBitmap* item_bitmap=new Graphics::TBitmap;
	item_bitmap->Width=24; item_bitmap->Height=64;
	item_bitmap->Canvas->Brush->Color=smc.pal[0];
	item_bitmap->Canvas->FillRect(TRect(0,0,24,64));
	smc.drawblock(item_bitmap,0,0,Index,3,8,32,smc.ggblock,smc.ggtile,0x20,State.Contains(odSelected));
	ComboBoxGg->Canvas->Draw(Rect.left,Rect.top,item_bitmap);
	ComboBoxGg->Canvas->TextOutA(24+Rect.left,Rect.top,IntToHex(Index,2));
	delete item_bitmap;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxFgChange(TObject *Sender)
{
	if(!is_open) return;
	if(auto_mode) {
          DoAuto('f');
        } else {
	  smc.level.block_fg[ComboBoxTile->ItemIndex]=ComboBoxFg->ItemIndex;
	  DrawRoom();
        }
        ReloadCurrentTile(); // TODO
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxGgChange(TObject *Sender)
{
	if(!is_open) return;
	if(auto_mode) {
          DoAuto('g');
        } else {
	  smc.level.block_gg[ComboBoxTile->ItemIndex]=ComboBoxGg->ItemIndex;
	  DrawRoom();
        }
        ReloadCurrentTile(); // TODO
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxObChange(TObject *Sender)
{
	if(!is_open) return;
        int new_object = ComboBoxOb->ItemIndex;
	if(auto_mode) {
          DoAuto('o');
        } else {
	  smc.level.block_object[ComboBoxTile->ItemIndex] = new_object;
	  DrawRoom();
        }
        ReloadCurrentTile(); // TODO
        ShowHideDoorEvents();
}

void TMainForm::ShowHideDoorEvents()
{
        int new_object = ComboBoxOb->ItemIndex;
        bool can_trigger = (new_object==4 /*open*/ || new_object==5 /*close*/ );
        EditRm->Visible = can_trigger;
        EditPs->Visible = can_trigger;
        CheckBoxNx->Visible = can_trigger;
        LabelModifiers->Caption = can_trigger ? "Door events" : "Modifier";
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Starthere1Click(TObject *Sender)
{
	smc.level.start_room=smc.curr_room;
	smc.level.start_tilepos=last_clicked_row*10+last_clicked_column;
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Guardhere1Click(TObject *Sender)
{
	smc.level.guard_tilepos[smc.curr_room]=last_clicked_row*10+last_clicked_column;
	int x=smc.level.guard_type_dir[smc.curr_room]&0x7F;
	if(x<2 || x>19) smc.level.guard_type_dir[smc.curr_room]=9;
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Deleteguard1Click(TObject *Sender)
{
	smc.level.guard_tilepos[smc.curr_room]=255;
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Flipstart1Click(TObject *Sender)
{
	smc.level.start_dir=smc.level.start_dir?0:255;
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Flipguard1Click(TObject *Sender)
{
	smc.level.guard_type_dir[smc.curr_room]^=0x80;
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Guardtype1Click(TObject *Sender)
{
	int x=smc.level.guard_type_dir[smc.curr_room],tp=x&0x7F;
/*	AnsiString s=InputBox("Guard","Guard","0");
	try{x=StrToInt(s);}catch(...){x=0;}*/
	tp=Select(guard_names,COUNT(guard_names),tp,"Select guard type");
	x=x&0x80|tp;
	smc.level.guard_type_dir[smc.curr_room]=x;
	DrawRoom();
}
//---------------------------------------------------------------------------
/*
int TMainForm::Select(const char* list[],int n,int def,AnsiString s){
	int i;
	TForm* dform; TListBox* dlist; TButton* dok,*dcan;
	dform=new TForm(Application);
	dlist=new TListBox(Application);
	dok=new TButton(Application);
	dcan=new TButton(Application);
	dlist->Parent=dform;
	dok->Parent=dform;
	dcan->Parent=dform;
	dform->Caption=s;
	for(i=0;i<n;i++) dlist->Items->Add(list[i]);
	dlist->ItemIndex=def;
	dlist->Height=(dlist->ItemHeight+1)*n;
        //dlist->OnDblClick = ???;
	dok->Left=0; dok->Top=dlist->Height; dok->Caption="OK";
	dok->ModalResult=mrOk; dok->Default=true; dok->Width=dlist->Width/2;
	dcan->Left=dlist->Width/2; dcan->Top=dlist->Height; dcan->Caption="Cancel";
	dcan->ModalResult=mrCancel; dcan->Cancel=true; dcan->Width=dlist->Width/2;
	dform->AutoSize=true;
	dform->Position=poMainFormCenter;
	dform->BorderIcons=TBorderIcons();
	dform->BorderStyle=bsSingle;
	if(dform->ShowModal()==mrOk){
		i=dlist->ItemIndex;
	}else{
		i=def;
	}
	delete dlist;
	delete dok;
	delete dcan;
	delete dform;
	return i;
}
*/
//---------------------------------------------------------------------------

void __fastcall TMainForm::Guardskill1Click(TObject *Sender)
{
	int x=smc.level.guard_sk[smc.curr_room];
/*	AnsiString s=InputBox("skill","skill",IntToStr(x));
	try{x=StrToInt(s);}catch(...){}*/
	x=InputNum("skill","skill",x);
	smc.level.guard_sk[smc.curr_room]=x;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Roomlinks1Click(TObject *Sender)
{
	TForm* dform; TButton* dok,*dcan; TEdit* dl,*dr,*du,*dd;
	dform=new TForm(Application);
	dform->Caption="Room links";
	dform->Width=150; dform->Height=200;
	dok=new TButton(Application); dok->Parent=dform; dok->Caption="OK"; dok->Width=50;
	dok->Left=10; dok->Top=120; dok->Default=true; dok->ModalResult=mrOk;
	dcan=new TButton(Application); dcan->Parent=dform; dcan->Caption="Cancel"; dcan->Width=50;
	dcan->Left=60; dcan->Top=120; dcan->Cancel=true; dcan->ModalResult=mrCancel;
	dl=new TEdit(Application); dl->Parent=dform; dl->Left=10; dl->Top=50; dl->Width=30;
	dr=new TEdit(Application); dr->Parent=dform; dr->Left=90; dr->Top=50; dr->Width=30;
	du=new TEdit(Application); du->Parent=dform; du->Left=50; du->Top=10; du->Width=30;
	dd=new TEdit(Application); dd->Parent=dform; dd->Left=50; dd->Top=90; dd->Width=30;
	dform->Position=poMainFormCenter;
	dform->BorderIcons=TBorderIcons();
	dform->BorderStyle=bsSingle;
	dl->Text=IntToStr(smc.level.room_links[smc.curr_room][0]);
	dr->Text=IntToStr(smc.level.room_links[smc.curr_room][1]);
	du->Text=IntToStr(smc.level.room_links[smc.curr_room][2]);
	dd->Text=IntToStr(smc.level.room_links[smc.curr_room][3]);
	if(dform->ShowModal()==mrOk){
		smc.level.room_links[smc.curr_room][0]=StrToInt(dl->Text);
		smc.level.room_links[smc.curr_room][1]=StrToInt(dr->Text);
		smc.level.room_links[smc.curr_room][2]=StrToInt(du->Text);
		smc.level.room_links[smc.curr_room][3]=StrToInt(dd->Text);
		DrawRoom();
	}
	delete dok; delete dcan; delete dl; delete dr; delete du; delete dd;
	delete dform;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ComboBoxModChange(TObject *Sender)
{
	if(!is_open) return;
	for(int i=0;i<3;i++) for(int j=0;j<10;j++) if(smc.sel[i][j]) smc.level.modifiers[smc.curr_room][i][j]=ComboBoxMod->ItemIndex;
	GetMod(ComboBoxMod->ItemIndex);
	DrawRoom();
}
//---------------------------------------------------------------------------
void TMainForm::GetMod(int index){
	int room,tilepos; bool next;
	smc.get_door_event(index, room, tilepos, next);
	is_open=false;
	ComboBoxMod->ItemIndex = index;
	EditRm->Text=IntToStr(room);
	EditPs->Text=IntToStr(tilepos);
	CheckBoxNx->Checked = next;
	is_open=true;
}
//---------------------------------------------------------------------------
void TMainForm::SetMod(int index){
	try{
		int room = StrToInt(EditRm->Text);
		int tilepos = StrToInt(EditPs->Text);
		bool next = CheckBoxNx->Checked;
		smc.set_door_event(index, room, tilepos, next);
	}catch(...){GetMod(index);}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::EditRmChange(TObject *Sender)
{
	if(is_open) SetMod(ComboBoxMod->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::EditPsChange(TObject *Sender)
{
	if(is_open) SetMod(ComboBoxMod->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CheckBoxNxClick(TObject *Sender)
{
	if(is_open) SetMod(ComboBoxMod->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CheckListBoxFlagsClick(TObject *Sender)
{
	if(!is_open) return;
	if(auto_mode) return DoAuto('F');
	byte fl = GetFlags(CheckListBoxFlags);
	//smc.level.block_flags_back_anim[ComboBoxTile->ItemIndex]=fl;
	smc.set_block_flags(ComboBoxTile->ItemIndex,fl);
        ReloadCurrentTile(); // TODO
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Export1Click(TObject *Sender)
{
 if(!is_open) return;
 if(SaveDialogExport->Execute()){
	 TMemoryStream* ms=new TMemoryStream;
	 ms->Write(&smc.level,sizeof(TLevel));
	 ms->SaveToFile(SaveDialogExport->FileName);
	 delete ms;
 }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Import1Click(TObject *Sender)
{
 if(!is_open) return;
 if(OpenDialogImport->Execute()){
	 TMemoryStream* ms=new TMemoryStream;
	 ms->LoadFromFile(OpenDialogImport->FileName);
	 ms->Read(&smc.level,sizeof(TLevel));
	 delete ms;
	 smc.curr_room=smc.level.start_room;
	 DrawRoom();
 }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Automatic1Click(TObject *Sender)
{
 Automatic1->Checked=true;
 auto_mode=true;
 //ComboBoxTile->Enabled=false;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Manual1Click(TObject *Sender)
{
 Manual1->Checked=true;
 auto_mode=false;
 //ComboBoxTile->Enabled=true;
}
//---------------------------------------------------------------------------

void TMainForm::DoAuto(int what){
// Change a single property of the selected foreground tiles without affecting other parts of the level.
	byte
          new_fore_back=ComboBoxFg->ItemIndex,
          new_fore_fore=ComboBoxGg->ItemIndex,
          new_object=ComboBoxOb->ItemIndex,
          new_flags=GetFlags(CheckListBoxFlags);
	for(int i=0;i<3;i++) for(int j=0;j<10;j++) if(smc.sel[i][j])
        {
		byte current_tile = smc.level.foreground[smc.curr_room][i][j];
		byte fore_back = smc.level.block_fg[current_tile];
		byte fore_fore = smc.level.block_gg[current_tile];
		byte object = smc.level.block_object[current_tile];
		//fl=smc.level.block_flags_back_anim[t];
		byte flags = smc.get_block_flags(current_tile);
		switch(what){
			case 'f': fore_back = new_fore_back; break;
			case 'g': fore_fore = new_fore_fore; break;
			case 'o': object = new_object; break;
			case 'F': flags = new_flags; break;
		}
		smc.level.foreground[smc.curr_room][i][j]=0;
                // Find an already existing block with the correct properties:
                int new_tile;
		for(new_tile = 0; new_tile < 256; new_tile++){
			if(smc.level.block_fg[new_tile] == fore_back
                          && smc.level.block_gg[new_tile] == fore_fore
                          && smc.level.block_object[new_tile] == object
                          && smc.get_block_flags(new_tile) == flags
                        ) break;
		}
		if(new_tile < 256){
                        // Found: use that.
			smc.level.foreground[smc.curr_room][i][j] = new_tile;
		}else{
                        // Not found: replace an unused block with the new one.
                        // Find used blocks.
                        bool used[256];
			for(int t=0;t<256;t++) used[t]=false;
			for(int rm2=0;rm2<24;rm2++) for(int s=0;s<3;s++) for(int o=0;o<10;o++) used[smc.level.foreground[rm2][s][o]]=true;
                        // Find an unused block.
                        // Skip these: Block 255 = wall of room 255. Block 254 = permanently triggered button.
                        int new_tile;
			for(new_tile = 0; new_tile < 254; new_tile++) if(!used[new_tile]) break;
			if(new_tile < 254){
				smc.level.block_fg[new_tile]=fore_back;
				smc.level.block_gg[new_tile]=fore_fore;
				smc.level.block_object[new_tile]=object;
				//smc.level.block_flags_back_anim[t]=fl;
				smc.set_block_flags(new_tile, flags);
				smc.level.foreground[smc.curr_room][i][j] = new_tile;
			}else{
				ShowMessage("No room for tile!");
			}
		}
	}
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Labels1Click(TObject *Sender)
{
	Labels1->Checked=smc.show_labels=!smc.show_labels;
	if(!is_open) return;
	DrawRoom();
	ComboBoxTile->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Clearallroomsandtiles1Click(TObject *Sender)
{
 if(Application->MessageBox("Do you really want to clear all rooms and tiles?","Clear all rooms and tiles",MB_YESNO)==IDYES){
	 ClearAll(true);
	 DrawRoom();
 }
}
//---------------------------------------------------------------------------

void TMainForm::ClearAll(bool tiles){
#define fill(what,byte) memset(&what,byte,sizeof(what))
/*	 memset(&smc.level,0,sizeof(smc.level));
	 memset(&smc.level.door_events_1,255,sizeof(smc.level.door_events_1));
	 memset(&smc.level.door_events_2,255,sizeof(smc.level.door_events_2));
	 memset(&smc.level.room_links,255,sizeof(smc.level.room_links));
	 memset(&smc.level.guard_tilepos,255,sizeof(smc.level.guard_tilepos));*/
	 if(tiles){
		 fill(smc.level.block_gg,0);
		 fill(smc.level.block_fg,0);
		 fill(smc.level.block_object,0);
		 fill(smc.level.block_flags_back_anim,0);
	 }
	 fill(smc.level.background,0);
	 fill(smc.level.foreground,0);
	 fill(smc.level.modifiers,0);
	 fill(smc.level.room_links,255);
	 smc.level.start_room=0;
	 smc.level.start_tilepos=0;
	 smc.level.start_dir=0;
	 smc.level.zero=0;
	 fill(smc.level.guard_tilepos,255);
	 fill(smc.level.guard_type_dir,0);
	 fill(smc.level.guard_sk,0);
	 fill(smc.level.guard_uk1,0);
	 fill(smc.level.guard_uk2,0);
	 fill(smc.level.guard_uk3,0);
	 fill(smc.level.door_events_1,255);
	 fill(smc.level.door_events_2,255);
#undef fill
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Clearallrooms1Click(TObject *Sender)
{
 if(Application->MessageBox("Do you really want to clear all rooms?","Clear all rooms",MB_YESNO)==IDYES){
	 ClearAll(false);
	 DrawRoom();
 }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Clearthisroom1Click(TObject *Sender)
{
 if(Application->MessageBox("Do you really want to clear this room?","Clear this room",MB_YESNO)==IDYES){
	 memset(&smc.level.background[smc.curr_room],0,sizeof(smc.level.background[smc.curr_room]));
	 memset(&smc.level.foreground[smc.curr_room],0,sizeof(smc.level.foreground[smc.curr_room]));
	 memset(&smc.level.modifiers[smc.curr_room],0,sizeof(smc.level.modifiers[smc.curr_room]));
	 DrawRoom();
 }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Jumptoroom1Click(TObject *Sender)
{
// AnsiString s=IntToStr(rm);
 int rm2=smc.curr_room;
/* s=InputBox("Which room do you want to jump to? (0-23)","Jump to room",s);
 try{
	 rm2=StrToInt(s);
 }catch(...){
	 //
 }*/
 rm2=InputNum("Jump to room","Which room do you want to jump to? (0-23)",smc.curr_room);
 if(rm2>=0 && rm2<=23){
	 smc.curr_room=rm2;
	 DrawRoom();
 }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Changetype1Click(TObject *Sender)
{
 int lt=Select(level_type_names,COUNT(level_type_names),smc.level_type,"Change level type");
 //*((char*)smc.ms_smc->Memory+0x36EE+SMCHD+level)=smc.level_type=lt;
 smc.set_level_type(smc.curr_level,lt);
 DrawRoom();
}
//---------------------------------------------------------------------------

void TMainForm::RealignStuff()
{
	//Doublesize1->Checked=!Doublesize1->Checked;
	//scale=Doublesize1->Checked?2:1;
	PaintBox1->OnPaint(NULL);
	ButtonUp->Top = Panel1->Top + Panel1->Height - 2;
	//PaintBox1->Top=ButtonUp->Top+ButtonUp->Height;
	ButtonUp->Left=PaintBox1->Left+PaintBox1->Width/2-ButtonUp->Width/2;
	ButtonLeft->Top=PaintBox1->Top+PaintBox1->Height/2-ButtonUp->Height/2;
	ButtonDown->Left=PaintBox1->Left+PaintBox1->Width/2-ButtonUp->Width/2;
	ButtonRight->Top=PaintBox1->Top+PaintBox1->Height/2-ButtonUp->Height/2;
	ButtonRight->Left=PaintBox1->Left+PaintBox1->Width+20;
	ButtonDown->Top=PaintBox1->Top+PaintBox1->Height+0;
	PlaceSidebtn();
}
//---------------------------------------------------------------------------

void TMainForm::PlaceSidebtn(){
	int i;
	AnsiString s;
	for(i=0;i<10;i++){
		sidebtn[i]->Width=PaintBox1->Width/10;
		sidebtn[i]->Height=16;
		sidebtn[i]->Left=PaintBox1->Left+i*PaintBox1->Width/10;
		sidebtn[i]->Top=PaintBox1->Top-sidebtn[i]->Height;
		s.printf("C%d",i);
		sidebtn[i]->Caption=s;
		sidebtn[i]->Hint="Select this column";
	}
	for(i=0;i<3;i++){
		sidebtn[i+10]->Width=16;
		sidebtn[i+10]->Height=PaintBox1->Height/3;
		sidebtn[i+10]->Left=PaintBox1->Left-sidebtn[i+10]->Width;
		sidebtn[i+10]->Top=PaintBox1->Top+i*PaintBox1->Height/3;
		s.printf("L%d",i);
		sidebtn[i+10]->Caption=s;
		sidebtn[i+10]->Hint="Select this line";
	}
	sidebtn[13]->Width=16;
	sidebtn[13]->Height=16;
	sidebtn[13]->Left=PaintBox1->Left-sidebtn[13]->Width;
	sidebtn[13]->Top=PaintBox1->Top-sidebtn[13]->Height;
	sidebtn[13]->Caption="all";
	sidebtn[13]->Hint="Select whole room";
}

//---------------------------------------------------------------------------

void __fastcall TMainForm::FormClose(TObject *Sender, TCloseAction &Action)
{
 int i;
 for(i=0;i<14;i++){
	 delete (sidebtn[i]); // Doesn't work in FormDestroy
 }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SideClick(TObject *Sender){
	if(!is_open) return;
	int tag=((TButton*)Sender)->Tag,i,j;
	if(!(GetAsyncKeyState(VK_CONTROL)&0x80000000)) smc.clear_selection();
	if(tag>=0 && tag<=9){
		j=tag;
		for(i=0;i<3;i++) smc.sel[i][j]=true;
	}
	if(tag>=10 && tag<=12){
		i=tag-10;
		for(j=0;j<10;j++) smc.sel[i][j]=true;
	}
	if(tag==13){
		for(i=0;i<3;i++) for(j=0;j<10;j++) smc.sel[i][j]=true;
	}
	DrawRoom();
}
//---------------------------------------------------------------------------

int InputNum(AnsiString Caption,AnsiString Prompt,int Default){
	int x=Default;
	AnsiString s=InputBox(Caption,Prompt,IntToStr(x));
	try{x=StrToInt(s);}catch(...){}
	return x;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Hitpoints1Click(TObject *Sender)
{
	if(!is_open) return;
	AnsiString p;
	int tp=smc.level.guard_type_dir[smc.curr_room]&0x7F;
	byte* ad=(byte*)smc.ROM_pointer(0x80A5+tp);
	p.printf("The number of hitpoints for all \"%s\" guards in the game:",guard_names[tp]);
	int x=*ad;
	x=InputNum("Guard hitpoints",p,x);
	*ad=x;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Palettes1Click(TObject *Sender)
{
	if(!is_open) return;
	AnsiString p;
	int tp=smc.level.guard_type_dir[smc.curr_room]&0x7F;
	byte* ad=(byte*)smc.ROM_pointer(0x759E+tp);
	p.printf("The palette for all \"%s\" guards in the game:",guard_names[tp]);
	int x=*ad;
	x=InputNum("Guard palettes",p,x);
	*ad=x;
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Settings1Click(TObject *Sender)
{
	static const char* names[]={"fat","normal guard","shadow (prince)","skeleton","knight","jaffar","amazon","monster"};
	static const int sprites[]={212,244,276,308,340,372,936,988};
	static const int swords[]={3,4,5,6,7,10,4,4};
	static const char* props[]={"strike probability","restrike probability","block probability","impblockprob","advance probability","refractory timer","?","hit points","palette","sprite"};
	TForm* dform;
	TLabel**dlabel; TEdit**dedit; TComboBox*dcombo; TButton*dok,*dcan;
	int i;
	int tp=smc.level.guard_type_dir[smc.curr_room]&0x7F;
	if(smc.level.guard_tilepos[smc.curr_room]>=30 || tp<2 || tp>19){
		ShowMessage("There is no guard in this room!");
		return;
	}
	AnsiString s;
	dform=new TForm(Application);
	dform->Position=poMainFormCenter;
	dform->Height=12*30;
	// dform->Caption="Guard Settings";
	s.printf("Guard settings for all \"%s\" guards in the game:",guard_names[tp]);
	dform->Caption=s;
	dform->BorderIcons=TBorderIcons();
	dform->BorderStyle=bsSingle;
	dok=new TButton(Application);
	dok->Parent=dform;
	dok->Caption="OK";
	dok->Left=100;
	dok->Top=10*30;
	dok->Default=true;
	dok->ModalResult=mrOk;
	dcan=new TButton(Application);
	dcan->Parent=dform;
	dcan->Caption="Cancel";
	dcan->Left=200;
	dcan->Top=10*30;
	dcan->Cancel=true;
	dcan->ModalResult=mrCancel;
	dlabel=new TLabel*[10];
	for(i=0;i<10;i++){
		dlabel[i]=new TLabel(Application);
		dlabel[i]->Parent=dform;
		dlabel[i]->Caption=props[i];
		dlabel[i]->Left=25;
		dlabel[i]->Top=i*30+5;
	}
	dedit=new TEdit*[9];
	for(i=0;i<9;i++){
		dedit[i]=new TEdit(Application);
		dedit[i]->Parent=dform;
		dedit[i]->Left=125;
		dedit[i]->Top=i*30+5;
	}
	dcombo=new TComboBox(Application);
	dcombo->Parent=dform;
	dcombo->Left=125;
	dcombo->Top=9*30+5;
	dcombo->Style=csDropDownList;
	for(i=0;i<COUNT(names);i++){
		dcombo->Items->Add(names[i]);
	}
	for(i=0;i<8;i++){
		dedit[i]->Text=IntToStr(*(byte*)smc.ROM_pointer(0x8022-2+i*19+tp));
	}
	dedit[8]->Text=IntToStr(*(byte*)smc.ROM_pointer(0x759E+tp));
	int spr=*(word*)smc.ROM_pointer(0xBF80+(tp<<1));
	for(i=0;i<COUNT(sprites);i++){
		if(sprites[i]==spr) dcombo->ItemIndex=i;
	}
	if(dform->ShowModal()==mrOk){
		for(i=0;i<8;i++){
			*(byte*)smc.ROM_pointer(0x8022-2+i*19+tp)=StrToInt(dedit[i]->Text);
		}
		*(byte*)smc.ROM_pointer(0x759E+tp)=StrToInt(dedit[8]->Text);
		spr=dcombo->ItemIndex;
		*(word*)smc.ROM_pointer(0xBF80+(tp<<1))=sprites[spr];
		*(byte*)smc.ROM_pointer(0xC1C6-2+tp)=swords[spr];
		DrawRoom();
	}
	delete dcombo;
	for(i=0;i<10;i++) delete dlabel[i];
	delete[]dlabel;
	for(i=0;i<9;i++) delete dedit[i];
	delete[]dedit;
	delete dok; delete dcan;
	delete dform;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Changemusic1Click(TObject *Sender)
{
	AnsiString p;
	byte* ad=(byte*)smc.ROM_pointer(0x1145C+smc.curr_level);
	int x=*ad;
	x=InputNum("Level music","Music for current level (255 for none)",x);
	*ad=x;
	//DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Editenvpal1Click(TObject *Sender)
{
	if(!is_open) return;
	smc.editenvpal();
	RedrawAll();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Editspritespal1Click(TObject *Sender)
{
	if(!is_open) return;
	smc.editspritespal();
	RedrawAll();
}
//---------------------------------------------------------------------------
void TMainForm::RedrawAll(){
	DrawRoom();
	this->Refresh();
	ComboBoxBack->Refresh();
	ComboBoxFg->Refresh();
	ComboBoxGg->Refresh();
	ComboBoxTile->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Layer1Click(TObject *Sender)
{
	if(!is_open) return;
	smc.editlevelgr(1);
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Layer2Click(TObject *Sender)
{
	if(!is_open) return;
	smc.editlevelgr(2);
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Layer3Click(TObject *Sender)
{
	if(!is_open) return;
	smc.editlevelgr(3);
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::EditAnimGroupChange(TObject *Sender)
{
	int background=ComboBoxBack->ItemIndex;
	try{
		int anim=StrToInt(EditAnimGroup->Text);
		smc.set_back_anim(background,anim);
	}catch(...){
		EditAnimGroup->Text=IntToStr(smc.get_back_anim(background));
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::N1x1Click(TObject *Sender)
{
	scale = 1;
	RealignStuff();
	N1x1->Checked = true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::N2x1Click(TObject *Sender)
{
	scale = 2;
	RealignStuff();
	N2x1->Checked = true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::N3x1Click(TObject *Sender)
{
	scale = 3;
	RealignStuff();
	N3x1->Checked = true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::N4x1Click(TObject *Sender)
{
	scale = 4;
	RealignStuff();
	N4x1->Checked = true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Swappositions1Click(TObject *Sender)
{
	int rm2=smc.curr_room;
	rm2=InputNum("Swap room positions","Swap positions of current room with which room? (0-23)",smc.curr_room);
	if(rm2>=0 && rm2<=23){
		smc.swap_room_positions(smc.curr_room,rm2);
		DrawRoom();
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Swapdetails1Click(TObject *Sender)
{
	int rm2=smc.curr_room;
	rm2=InputNum("Swap room details","Swap details of current room with which room? (0-23)",smc.curr_room);
	if(rm2>=0 && rm2<=23){
		smc.swap_room_details(smc.curr_room,rm2);
		DrawRoom();
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Swaptransparent1Click(TObject *Sender)
{
	int rm2=smc.curr_room;
	rm2=InputNum("Swap room transparently","Swap current room with which room? (0-23)",smc.curr_room);
	if(rm2>=0 && rm2<=23){
		smc.swap_room_transparent(smc.curr_room,rm2);
		DrawRoom();
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Copyroom1Click(TObject *Sender)
{
	//TClipboard* clipboard = Clipboard();
	//TMemoryStream* ms_room = new TMemoryStream();
	//clipboard->Assign(ms_room);
	//delete ms_room;
	int room = smc.curr_room;
	memcpy(room_clipboard.background, smc.level.background[room], 30);
	memcpy(room_clipboard.foreground, smc.level.foreground[room], 30);
	memcpy(room_clipboard.modifiers, smc.level.modifiers[room], 30);
	room_clipboard.guard_tilepos = smc.level.guard_tilepos[room];
	room_clipboard.guard_type_dir = smc.level.guard_type_dir[room];
	room_clipboard.guard_sk = smc.level.guard_sk[room];
	room_clipboard.guard_uk1 = smc.level.guard_uk1[room];
	room_clipboard.guard_uk2 = smc.level.guard_uk2[room];
	room_clipboard.guard_uk3 = smc.level.guard_uk3[room];
	room_clipboard_notempty = true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Pasteroom1Click(TObject *Sender)
{
	//TClipboard* clipboard = Clipboard();
	//if (clipboard->HasFormat(CF_TEXT)) {
	//	TMemoryStream* ms_room = new TMemoryStream();
	//	//ms_room-> ;
	//	delete ms_room;
	//}
	if (! room_clipboard_notempty) {
		return;
	}
	if (Application->MessageBox("Overwrite this room?","Paste",MB_YESNO) != IDYES) {
		return;
	}
	int room = smc.curr_room;
	memcpy(smc.level.background[room], room_clipboard.background, 30);
	memcpy(smc.level.foreground[room], room_clipboard.foreground, 30);
	memcpy(smc.level.modifiers[room], room_clipboard.modifiers, 30);
	smc.level.guard_tilepos[room] = room_clipboard.guard_tilepos;
	smc.level.guard_type_dir[room] = room_clipboard.guard_type_dir;
	smc.level.guard_sk[room] = room_clipboard.guard_sk;
	smc.level.guard_uk1[room] = room_clipboard.guard_uk1;
	smc.level.guard_uk2[room] = room_clipboard.guard_uk2;
	smc.level.guard_uk3[room] = room_clipboard.guard_uk3;
	DrawRoom();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Floorsandwalls1Click(TObject *Sender)
{
	if (!is_open) return;
	Floorsandwalls1->Checked = smc.show_floors_walls = !smc.show_floors_walls;
	DrawRoom();
	ComboBoxTile->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Editscrnpal1Click(TObject *Sender)
{
	if(!is_open) return;
	smc.editscrnpal();
	RedrawAll();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Edithcpal1Click(TObject *Sender)
{
	if(!is_open) return;
	smc.edithcpal();
	RedrawAll();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::Quit1Click(TObject *Sender)
{
	this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  CanClose = Application->MessageBox("Quit?","Quit?",MB_YESNO) == IDYES;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Hacks1Click(TObject *Sender)
{
  THacksForm::Open(&smc);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  // Move among rooms with shift + the arrow keys:
  if (Shift == TShiftState() << ssShift) {
    int new_room = -1;
    switch(Key) {
      case VK_LEFT:  GotoAdjacentRoom(0); break;
      case VK_RIGHT: GotoAdjacentRoom(1); break;
      case VK_UP:    GotoAdjacentRoom(2); break;
      case VK_DOWN:  GotoAdjacentRoom(3); break;
      case VK_PRIOR: new_room = smc.curr_room - 1; break; // page up
      case VK_NEXT:  new_room = smc.curr_room + 1; break; // page down
    }
    if (new_room >= 0 && new_room <= 23) {
      smc.curr_room = new_room;
      smc.clear_selection();
      DrawRoom();
    }
  }
}
//---------------------------------------------------------------------------


