//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "PaletteEdit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TPaletteEditForm *PaletteEditForm;
//---------------------------------------------------------------------------
__fastcall TPaletteEditForm::TPaletteEditForm(TComponent* Owner)
		  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
using namespace std;

bool TPaletteEditForm::edit(vector<TColor>& pal, const char** desc)
{
	vector<TPanel*> buttons;
	int n=pal.size();
	buttons.resize(n);
	const int bw=32,bh=bw;
	this->Position=poScreenCenter;
	for(int i=0;i<n;i++){
		buttons[i]=new TPanel(this);
		buttons[i]->Parent=this;
		buttons[i]->Width=bw;
		buttons[i]->Height=bh;
		buttons[i]->Left=(i&15)*bw;
		buttons[i]->Top=(i>>4)*bh;
		buttons[i]->Color=pal[i];
		buttons[i]->Tag=i;
		buttons[i]->OnClick=ButtonClick;
	}
	vector<TLabel*> labels;
	ClientWidth=16*bw;
	ClientHeight=((n+15)>>4)*bh;
	if (desc != NULL) {
		int maxw = this->ClientWidth;
		for(int i=0;desc[i] != NULL; ++i){
			labels.resize(i+1);
			labels[i]=new TLabel(this);
			labels[i]->Parent = this;
			labels[i]->Caption= desc[i];
			labels[i]->Left = bw*16+10;
			labels[i]->Top = i*bh + (bh - labels[i]->Height)/2;
			int currw= labels[i]->Left + labels[i]->Width;
			if (currw>maxw) maxw=currw;
		}
		this->ClientWidth=maxw;
	}
//	this->AutoSize=true;
//	int w=Width,h=Height;
//	this->AutoSize=false;
//	Width=w,Height=h;
	int maxh=Screen->Height-100;
	if(ClientHeight>maxh) ClientHeight=maxh;
	this->AutoScroll=true;
	mypal=&pal;
	this->ShowModal();
	for(int i=0;i<n;i++) delete buttons[i];
	for(int i=0;i<labels.size();i++) delete labels[i];
	buttons.clear();
	labels.clear();
	return true;
}
//---------------------------------------------------------------------------

void __fastcall TPaletteEditForm::ButtonClick(TObject *Sender)
{
 TPanel* s=(TPanel*)Sender;
 ColorDialog1->Color=(*mypal)[s->Tag];
 if(ColorDialog1->Execute()){
	 s->Color=ColorDialog1->Color;
	 (*mypal)[s->Tag]=ColorDialog1->Color;
 }
}
//---------------------------------------------------------------------------

