//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Select.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TSelectForm *SelectForm;
//---------------------------------------------------------------------------
__fastcall TSelectForm::TSelectForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

int Select(const char* list[], int n, int def, AnsiString title) {
  TSelectForm* dform = NULL;
  int result = def;
  try {
    dform = new TSelectForm(Application);
    dform->Caption = title;
    TListBox* dlist = dform->ListBox;
    for (int i = 0; i < n; i++)
      dlist->Items->Add(list[i]);
    dlist->ItemIndex = def;
    dform->ClientHeight = (dlist->ItemHeight + 1) * n + dform->ButtonsPanel->Height;

    if (dform->ShowModal() == mrOk) {
      result = dlist->ItemIndex;
    }
  } __finally {
    delete dform;
  }
  return result;
}
//---------------------------------------------------------------------------

void __fastcall TSelectForm::ButtonsPanelResize(TObject *Sender)
{
  OK->Left=0;
  OK->Width = ButtonsPanel->Width/2;
  Cancel->Left = ButtonsPanel->Width/2;
  Cancel->Width = ButtonsPanel->Width/2;
}
//---------------------------------------------------------------------------
void __fastcall TSelectForm::ListBoxDblClick(TObject *Sender)
{
  OK->Click();
}
//---------------------------------------------------------------------------
