//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Hacks.h"
#include <inifiles.hpp>
#include "uEditBase.h"
#include "uEditCombo.h"
#include "uEditNumber.h"
#include "uEditCheckbox.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
THacksForm *HacksForm;
//---------------------------------------------------------------------------
__fastcall THacksForm::THacksForm(TComponent* Owner)
        : TForm(Owner)
{
  FEditFrames = new TObjectList(false);
}

__fastcall THacksForm::~THacksForm()
{
  delete FEditFrames;
}
//---------------------------------------------------------------------------

void THacksForm::Open(TSMC* smc) {
  THacksForm *HacksForm = NULL;
  try{
    HacksForm = new THacksForm(Application);
    HacksForm->Fsmc = smc;
    HacksForm->Init();
    HacksForm->LoadAll();
    TModalResult result = HacksForm->ShowModal();
    if (result == mrOk) {
      HacksForm->SaveAll();
    }
  }__finally{
    delete HacksForm;
  }
}
//---------------------------------------------------------------------------
TStringList* Split(AnsiString text, AnsiString separator) {
  TStringList* Result = new TStringList();
  while(int index = text.Pos(separator)) {
    Result->Add(text.SubString(1, index - 1));
    text.Delete(1, index - 1 + separator.Length());
  }
  Result->Add(text);
  return Result;
}

int HexToInt(AnsiString str) {
  int result = -1;
  if (str.Length() >= 1 && str[1]=='x')
    result = StrToIntDef("0"+str, -1);
  else
    result = StrToIntDef(str, -1);
  return result;
}

AnsiString HexListToBytes(AnsiString str) {
  AnsiString result;
  TStringList* sl = NULL;
  try {
    sl = new TStringList();
    sl->CommaText = str;
    for(int i = 0; i < sl->Count; i++) {
      int b = HexToInt(sl->Strings[i]);
      if (b < 0 || b > 255) return AnsiString(); // invalid
      result += (char)b;
    }
  } __finally {
    delete sl;
  }
  return result;
}

void THacksForm::Init() {
  static const char hacks_filename[] = "hackedit/Hacks.txt";
  static const char lists_filename[] = "hackedit/Hacks_lists.txt";
  AnsiString path = ExtractFilePath(Application->ExeName);
  TStringList* sl_hacks = NULL;
  TStringList* sl_row = NULL;
  TMemIniFile* mi_lists = NULL;
  TStringList* sl_section = NULL;
  TWinControl* curr_parent = NULL;
  int ypos = 0;
  try{
    sl_hacks = new TStringList();
    sl_hacks->LoadFromFile(path + hacks_filename);
    //sl_row = new TStringList();
    //sl_row->Delimiter="\t";
    mi_lists = new TMemIniFile(path + lists_filename);
    sl_section = new TStringList();

    // Find headers
    sl_row = Split(sl_hacks->Strings[0], "\t");
    int name_pos = sl_row->IndexOf("name");
    int offset_pos = sl_row->IndexOf("offset");
    int type_pos = sl_row->IndexOf("type");
    int subtype_pos = sl_row->IndexOf("subtype");
    int default_pos = sl_row->IndexOf("default");

    TTabSheet* curr_page = NULL;
    TGroupBox* curr_group = NULL;
    TScrollBox* curr_scroll = NULL;
    for(int hack_index=1,hack_count=sl_hacks->Count; hack_index<hack_count; hack_index++){
      try{
        sl_row = Split(sl_hacks->Strings[hack_index], "\t");
        if (sl_row->Count<3) continue;
        AnsiString name = sl_row->Strings[name_pos];
        AnsiString type = sl_row->Strings[type_pos];
        if (type == "page"){
          curr_page = new TTabSheet(this);
          curr_page->PageControl = PageControlHacks;
          curr_page->Caption = name;
          curr_scroll = new TScrollBox(this);
          curr_scroll->Align = alClient;
          curr_scroll->Parent = curr_page;
          curr_group = NULL;
          curr_parent = curr_scroll;
          ypos = 0;
        } else if (type == "group") {
          if (curr_group != NULL) ypos = curr_group->Top + curr_group->Height;
          curr_group = new TGroupBox(this);
          curr_group->Align = alTop;
          curr_group->Caption = name;
          curr_group->Height = 0;
          curr_group->Top = ypos;
          curr_group->Parent = curr_scroll;
          curr_parent = curr_group;
          ypos = abs(curr_group->Font->Height); // top margin
        } else {
          /*
          TPanel* panel = new TPanel(this);
          panel->Parent = curr_parent;
          TLabel* label = new TLabel(this);
          label->Parent = panel;
          label->Caption = name;
          TControl* editcontrol = NULL;
          if (type == "number") {
            TEdit* edit = new TEdit(this);
            edit->Parent = panel;
            editcontrol = edit;
          } else if (mi_lists->SectionExists(type)) {
            TComboBox* combobox = new TComboBox(this);
            combobox->Parent = panel;
            combobox->Style = csDropDownList;
            mi_lists->ReadSection(type, sl_section);
            for (int list_index=0,list_count=sl_section->Count; list_index<list_count; list_index++) {
              AnsiString value_str = sl_section->Strings[list_index];
              int value = StrToInt(value_str);
              AnsiString name = mi_lists->ReadString(type, value_str, "???"); //sl_section->Values[value_str];
              combobox->Items->AddObject(name, (TObject*)value);
            }
            editcontrol = combobox;
          }
          if (NULL != editcontrol) {
            editcontrol->Left = 200;
          }
          panel->AutoSize = true;
          //panel->BringToFront();
          //panel->Align = alTop;
          panel->Top = ypos;
          ypos += panel->Height;
          if (NULL != curr_group) {
            curr_group->Height = max(curr_group->Height, panel->Top + panel->Height);
          }
          */
          AnsiString offset_str = sl_row->Strings[offset_pos];
          AnsiString default_str = sl_row->Strings[default_pos];
          AnsiString subtype = sl_row->Strings[subtype_pos];
          int offset = HexToInt(offset_str);
          Variant default_v = Null;

          TEditBase* editframe = NULL;
          if (type == "list" || type=="number") {
            if (mi_lists->SectionExists(subtype)) {
              TStringList* list = NULL;
              try {
                list = new TStringList();
                mi_lists->ReadSection(subtype, sl_section);
                for (int list_index=0,list_count=sl_section->Count; list_index<list_count; list_index++) {
                  AnsiString value_str = sl_section->Strings[list_index];
                  int value = StrToInt(value_str);
                  AnsiString name = mi_lists->ReadString(subtype, value_str, "???"); //sl_section->Values[value_str];
                  list->AddObject(name, (TObject*)value);
                }
                editframe = new TEditCombo(this);
                ((TEditCombo*)editframe)->Fill(list);
              } __finally {
                delete list;
              }
            } else {
              editframe = new TEditNumber(this);
              //editframe = new TEditText(this);
            }
            default_v = HexToInt(default_str);
          } else if (type == "toggle") {
            editframe = new TEditCheckbox(this);
            default_v = HexListToBytes(default_str);
            AnsiString checked_v = HexListToBytes(subtype);
            ((TEditCheckbox*)editframe)->CheckedValue = checked_v;
            //((TEditCheckbox*)editframe)->ChangeLength = checked_v.Length;
          }
          if (editframe != NULL) {
            editframe->Name = "editframe" + IntToStr(hack_index); // Against errors
            editframe->lName->Caption = name;
            editframe->Offset = offset;
            editframe->DefaultValue = default_v;
            editframe->SMC = Fsmc;
            editframe->Top = ypos;
            editframe->Align = alTop;
            editframe->Parent = curr_parent;
            FEditFrames->Add(editframe);
            ypos += editframe->Height;
            if (NULL != curr_group) {
              curr_group->Height = max(curr_group->Height, editframe->Top + editframe->Height + 10);
            }
          }
        }
      }__finally{
        delete sl_row;
      }
    } // for
  }__finally{
    delete sl_hacks;
    delete mi_lists;
    delete sl_section;
  }
}
//---------------------------------------------------------------------------

void THacksForm::LoadAll() {
  for(int i=0;i<FEditFrames->Count;++i){
    TEditBase* editframe = dynamic_cast<TEditBase*>(FEditFrames->Items[i]);
    if (editframe != NULL) {
      editframe->LoadValue();
    }
  }
}

void THacksForm::SaveAll() {
  for(int i=0;i<FEditFrames->Count;++i){
    TEditBase* editframe = dynamic_cast<TEditBase*>(FEditFrames->Items[i]);
    if (editframe != NULL) {
      editframe->SaveValue();
    }
  }
}

