//---------------------------------------------------------------------------


#ifndef uEditBaseH
#define uEditBaseH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "smc.h"
#include <Menus.hpp>
//---------------------------------------------------------------------------
class TEditBase : public TFrame
{
__published:	// IDE-managed Components
        TLabel *lName;
        TPopupMenu *pmEditor;
        TMenuItem *miReset;
        void __fastcall miResetClick(TObject *Sender);
private:	// User declarations
protected:
        int FOffset;
        TSMC* FSMC;
        void CheckDefaultValue();
        Variant FDefaultValue;
public:		// User declarations
        __fastcall TEditBase(TComponent* Owner);
        __property int Offset = {read=FOffset, write=FOffset};
        __property TSMC* SMC = {read=FSMC, write=FSMC};
        void virtual LoadValue() = 0;
        void virtual SaveValue() = 0;
        Variant virtual GetValue() = 0;
        void virtual SetValue(Variant NewValue) = 0;
        __property Variant DefaultValue = {read=FDefaultValue, write=FDefaultValue};
        __property Variant Value = {read=GetValue, write=SetValue};
};
//---------------------------------------------------------------------------
extern PACKAGE TEditBase *EditBase;
//---------------------------------------------------------------------------
#endif
