//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "uEditCheckbox.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "uEditBase"
#pragma resource "*.dfm"
TEditCheckbox *EditCheckbox;
//---------------------------------------------------------------------------
__fastcall TEditCheckbox::TEditCheckbox(TComponent* Owner)
        : TEditBase(Owner)
{
}
//---------------------------------------------------------------------------
Variant TEditCheckbox::GetValue() {
  switch (cbValue->State) {
    case cbUnchecked: return FDefaultValue;
    case cbChecked: return FCheckedValue;
    case cbGrayed: return Null;
  }
  return Null;
}

void TEditCheckbox::SetValue(Variant NewValue) {
  if (NewValue == FDefaultValue) cbValue->State = cbUnchecked;
  else if (NewValue == FCheckedValue) cbValue->State = cbChecked;
  else cbValue->State = cbGrayed;
  CheckDefaultValue();
}

void TEditCheckbox::LoadValue() {
  AnsiString v;
  int length = ((AnsiString)DefaultValue).Length();
  for (int i = 0; i < length; i++) {
    v += (char) *(byte*)FSMC->ROM_pointer(FOffset + i);
  }
  Value = v;
}

void TEditCheckbox::SaveValue() {
  Variant va = Value;
  if (VarIsNull(va)) return;
  AnsiString v = va;
  for (int i = 0; i < v.Length(); i++) {
    *(byte*)FSMC->ROM_pointer(FOffset + i) = v[i+1];
  }
}

void __fastcall TEditCheckbox::cbValueClick(TObject *Sender)
{
  CheckDefaultValue();
}
//---------------------------------------------------------------------------
