//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "uEditCombo.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "uEditBase"
#pragma resource "*.dfm"
TEditCombo *EditCombo;
//---------------------------------------------------------------------------
__fastcall TEditCombo::TEditCombo(TComponent* Owner)
        : TEditBase(Owner)
{
}
//---------------------------------------------------------------------------

Variant TEditCombo::GetValue() {
  int v = cbValue->ItemIndex;
  if (v >= 0) v = (int)cbValue->Items->Objects[v];
  return v;
}

void TEditCombo::SetValue(Variant NewValue) {
  cbValue->ItemIndex = -1;
  for(int i = 0; i < cbValue->Items->Count; ++i) {
    if ((int)NewValue == (int)cbValue->Items->Objects[i]) {
      cbValue->ItemIndex = i; break;
    }
  }
  CheckDefaultValue();
}

void TEditCombo::LoadValue() {
  Value = *(byte*)FSMC->ROM_pointer(FOffset);
}

void TEditCombo::SaveValue() {
  int v = Value;
  if (v >= 0 && v <= 255)
    *(byte*)FSMC->ROM_pointer(FOffset) = v;
}

void TEditCombo::Fill(TStrings* list) {
  cbValue->Items = list;
}

void __fastcall TEditCombo::cbValueClick(TObject *Sender)
{
  CheckDefaultValue();
}
//---------------------------------------------------------------------------

