//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "smc.h"
#include <stdio.h>
#include "PaletteEdit.h"
#include "LevelGraphicsEdit.h"

using namespace std;

const char* object_names[0x2C]={
	"(none)","01","loose","03","open","close","door","leveldoor end",
	"mirror","skel","sword","0Btorch","chomper","guillotine","spike","0F",
	"crusher","11","heal potion","life potion","hurt potion","upside down potion","slow fall potion","debris",
	"door top","fire","potion of warp","1Bdown only","kill potion","1Dtorch","log","1F",
	"stars","21torch","22torch","teleport","leveldoor begin","25","26","lava",
	"skel cont","skull?",">>>","<<<"};
const char* guard_names[0x19]={
	"[BAD] prince garbage","[BAD] freeze","dead purple","skel","brown skel","golden skel","amazon","fat",
	"shadow","green","greenish blue","blue","red","purple","blueface","red knight",
	"blue knight","monster","Jaffar","dead","[BAD]","[BAD]","[BAD] freeze","[BAD] torture","[BAD] freeze"
};
const char* level_names[0x1B]={
	"LEVEL 1","LEVEL 2","LEVEL 3","LEVEL 4","LEVEL 5","LEVEL 6","LEVEL 7","LEVEL 8",
	"LEVEL 9","LEVEL 10","LEVEL 11","LEVEL 12","LEVEL 13","LEVEL 14","LEVEL 15","LEVEL 16",
	"LEVEL 17","LEVEL 18","LEVEL 19","LEVEL 20","Jaffar","Demo","TRAINING 1","TRAINING 2",
	"TRAINING 3","TRAINING 4","TRAINING 5"
};
const char* level_type_names[10]={
	"blue dungeon","pink palace","grey palace","red dungeon","green palace","brown dungeon",
	"red palace","level 20","jaffar","demo red palace"
};

void create_selected_palette(TColor* palette, TColor* selected_palette, int count);

//---------------------------------------------------------------------------
TSMC::TSMC(){
	show_labels=false;
	ms_smc=NULL;
	ms_data=NULL; ndata=0;
	bgblock=NULL; bgtile=NULL;
	fgblock=NULL; fgtile=NULL;
	ggblock=NULL; ggtile=NULL;
	pal=NULL;
	bg_rest=fg_rest=gg_rest=NULL;
	clear_selection();
	show_floors_walls = false;
}
//---------------------------------------------------------------------------
TSMC::~TSMC(){
	clear();
}
//---------------------------------------------------------------------------
bool TSMC::opensmc(AnsiString filename){
	{
		int fsize;
		FILE* fp=fopen(filename.c_str(),"rb");
		if(!fp) return false;
		fseek(fp,0,SEEK_END);
		fsize=ftell(fp);
		fclose(fp);
		if(fsize==0x100000) SMCHD=0;
		else if(fsize==0x100200) SMCHD=0x200;
		else { ShowMessage("ROM has bad size!"); return false; }
	}
	clear();
	ms_smc=new TMemoryStream;
	ms_smc->LoadFromFile(filename);
	unsigned __int32* sa=NULL,ad;
	ms_smc->Position=0x20000+SMCHD;
	ndata=1;
	for(int i=0;i<ndata;i++){
		word of; byte bank;
		ms_smc->Read(&of,2);
		ms_smc->Read(&bank,1);
		ad=(bank<<15)|(of&0x7FFF);
		if(!i){
			ndata=(ad-0x20000)/3;
			sa=new unsigned __int32[ndata+1];
		}
		sa[i]=ad;
	}
	ms_data=new TMemoryStream*[ndata];
	if (sa[ndata-1]<0x78000) {
		sa[ndata]=0x78000;
	} else {
		sa[ndata]=0xE8000;
	}
	for(int i=0;i<ndata;i++){
		ms_data[i]=new TMemoryStream;
		int len;
		// If the resources grow too big:
		if(sa[i+1]>0x78000 && sa[i]<0x78000) {
			len = 0x78000-sa[i];
			// Cut the length of the last resource in the first area:
			char* mem = (char*)ms_smc->Memory;
			while (mem[sa[i]+len-1]==0) len--;
		} else {
			len=sa[i+1]-sa[i];
		}
		ms_smc->Position=sa[i]+SMCHD;
		if(len) ms_data[i]->CopyFrom(ms_smc,len);
	}
//	lastsa=sa[91];
	delete[]sa;
	return true;
}
//---------------------------------------------------------------------------
void TSMC::clear(){
	if(ms_smc){ delete ms_smc; ms_smc=NULL; }
	if(ms_data){
		for(int i=0;i<ndata;i++){
			if(ms_data[i]){ delete ms_data[i]; ms_data[i]=NULL; }
		}
		delete[]ms_data;
		ms_data=NULL;
	}
	close_level_graphics();
	clear_selection();
}
//---------------------------------------------------------------------------
void decompress_level_part(TMemoryStream* ms_in, TMemoryStream* ms_out, int length);

void TSMC::openlevel(int new_level){
	TMemoryStream* ms_level_compressed = ms_data[41 + new_level];
	TMemoryStream* ms_level = new TMemoryStream;
//	ms_level_compressed->SaveToFile("dump");
	ms_level_compressed->Position = 0;
	ms_level->SetSize(sizeof(TLevel));
	decompress_level_part(ms_level_compressed, ms_level, 720); // background
	decompress_level_part(ms_level_compressed, ms_level, 720); // foreground
	decompress_level_part(ms_level_compressed, ms_level, 720); // modifiers
	decompress_level_part(ms_level_compressed, ms_level, 256); // block_gg
	decompress_level_part(ms_level_compressed, ms_level, 256); // block_fg
	decompress_level_part(ms_level_compressed, ms_level, 256); // block_object
	decompress_level_part(ms_level_compressed, ms_level, 256); // block_flags_back_anim
	decompress_level_part(ms_level_compressed, ms_level, 244); // ...
	decompress_level_part(ms_level_compressed, ms_level, 256); // door_events_1
	decompress_level_part(ms_level_compressed, ms_level, 256); // door_events_2
	ms_level->Position=0;
	ms_level->Read(&level,sizeof(TLevel));
	delete ms_level;
	curr_level = new_level;
	level_type = *(char*)ROM_pointer(0x36EE + curr_level);
	object_level_type = *(char*)ROM_pointer(0xED08 + curr_level);
	open_level_graphics(level_type);
}

void decompress_level_part(TMemoryStream* ms_in, TMemoryStream* ms_out, int length) {
	int start = ms_out->Position, end = ms_out->Position + length;
	while(ms_out->Position<end){
		byte compression_type;
		ms_in->Read(&compression_type,1);
		if (compression_type&0x80) {
			if(compression_type&0x7F) ms_out->CopyFrom(ms_in, compression_type&0x7F);
		} else {
			byte ch;
			word ad;
			ms_in->Read(&ch,1); int n=ch?ch:256; 
			switch (compression_type) {
				case 1: // sequence of identical bytes
					ms_in->Read(&ch,1);
					for(int i=0;i<n;i++) ms_out->Write(&ch,1);
				break;
				case 2: // sequence of increasing bytes
					ms_in->Read(&ch,1);
					for(int i=0;i<n;i++,ch++) ms_out->Write(&ch,1);
				break;
				case 3: // sequence of decreasing bytes
					ms_in->Read(&ch,1);
					for(int i=0;i<n;i++,ch--) ms_out->Write(&ch,1);
				break;
				case 4: // copy of some previous bytes (1-byte offset)
					ms_in->Read(&ch,1);
					ad = ch;
					goto copy;
				case 5: // copy of some previous bytes (2-byte offset)
					ms_in->Read(&ad,2);
				copy: {
					byte* p=(byte*)ms_out->Memory+start+ad;
					for(int i=0;i<n;i++,p++) ms_out->Write(p,1);
				}
				break;
				default: throw Exception("error in decompress_level_part : "+IntToStr((int)ch));
			}
		}
	}
}
//---------------------------------------------------------------------------
void decode_palette(TMemoryStream* ms, TColor*& palette, int count);

void TSMC::open_level_graphics(int level_type){
	close_level_graphics();
	ms_data[level_type*4+1]->Position=0;
	ms_data[level_type*4+2]->Position=0;
	ms_data[level_type*4+3]->Position=0;
	ms_data[level_type*4+4]->Position=0;
	decode_environment_layer(ms_data[level_type*4+1],bgblock,bgtile,3,8,16,0x100,0x200,8,9,bg_rest);
	decode_environment_layer(ms_data[level_type*4+2],fgblock,fgtile,6,8,32,0x100,0x100,8,8,fg_rest);
	decode_environment_layer(ms_data[level_type*4+3],ggblock,ggtile,3,8,32,0x100,0x100,8,8,gg_rest);
	decode_palette(ms_data[level_type*4+4],pal,256);
	selected_pal = new TColor[256];
	create_selected_palette(pal,selected_pal,128);
	memset(gr_edited,0,sizeof(gr_edited));
}

void TSMC::close_level_graphics(){
	if(bgblock){ delete[]bgblock; bgblock=NULL; }
	if(bgtile){ delete[]bgtile; bgtile=NULL; }
	if(fgblock){ delete[]fgblock; fgblock=NULL; }
	if(fgtile){ delete[]fgtile; fgtile=NULL; }
	if(ggblock){ delete[]ggblock; ggblock=NULL; }
	if(ggtile){ delete[]ggtile; ggtile=NULL; }
	if(pal){ delete[]pal; pal=NULL; }
	if(selected_pal){ delete[]selected_pal; selected_pal=NULL; }
	//if(bm_torch){ delete bm_torch; bm_torch=NULL; }
}
//---------------------------------------------------------------------------
void decode_mapping(TMemoryStream* ms, int n, int value_bits, word* mapping);
void decodeblock(TMemoryStream* ms,int n,int si,word* ar,bool big);
void decodetile16(TMemoryStream* ms,int n,byte* ar);
void decodetile32(TMemoryStream* ms,int n,byte* ar);

void TSMC::decode_environment_layer(TMemoryStream* ms_in, word*& blocks, byte*& tiles,
        int block_width, int block_height, int tile_size, int n_blocks, int n_tiles, int block_value_bits, int tile_value_bits,
		TMemoryStream*&rest) {
	if(rest!=NULL){ delete rest; rest=NULL; }
	{
		word n_stored_blocks;
		ms_in->Read(&n_stored_blocks,2);
		word* mapping = new word[n_blocks];
		word* stored_blocks = new word[n_stored_blocks*block_width*block_height];
		decode_mapping(ms_in, n_blocks, block_value_bits, mapping);
		bool big = block_width==6;
		decodeblock(ms_in, n_stored_blocks, block_width*block_height, stored_blocks, big);
		blocks = new word[n_blocks*block_width*block_height];
		for(int i=0;i<n_blocks;i++){
			memcpy(blocks + i*block_width*block_height, stored_blocks + mapping[i]*block_width*block_height, block_width*block_height*2);
		}
		delete[]mapping;
		delete[]stored_blocks;
	}
/*	{
		FILE* fp;
		fp=fopen("dumpbgbl","wb");
		fwrite(bgblock,0x100,8*3*2,fp);
		fflush(fp); fclose(fp);
	}*/
	int restlen = ms_in->Size - ms_in->Position;
	int p0 = ms_in->Position;
	rest = new TMemoryStream();
	if (restlen > 0) rest->CopyFrom(ms_in, restlen);
	ms_in->Position = p0;
	{
		word n_stored_tiles;
		ms_in->Read(&n_stored_tiles,2);
		word* mapping = new word[n_tiles];
		byte* stored_tiles = new byte[n_stored_tiles*tile_size];
		decode_mapping(ms_in, n_tiles, tile_value_bits, mapping);
		if (tile_size == 16) decodetile16(ms_in, n_stored_tiles, stored_tiles); // 2 bpp
		if (tile_size == 32) decodetile32(ms_in, n_stored_tiles, stored_tiles); // 4 bpp
		tiles = new byte[n_tiles*tile_size];
		for(int i=0;i<n_tiles;i++){
			memcpy(tiles + i*tile_size, stored_tiles + mapping[i]*tile_size, tile_size);
		}
		delete[]mapping;
		delete[]stored_tiles;
	}
/*	{
		FILE* fp;
		fp=fopen("dumpbgti","wb");
		fwrite(bgtile,0x200,16,fp);
		fflush(fp); fclose(fp);
	}*/
}

void decode_mapping(TMemoryStream* ms, int n, int value_bits, word* mapping) {
	int ix=0;
	int mask_value = (1<<value_bits)-1;
	int mask_length_inc = (1<<(15-value_bits))-1;
	int mask_length_rep = (1<<(14-value_bits))-1;
	int max_increse = 1<<(15-value_bits);
	int max_repeat = 1<<(14-value_bits);
	while(ix<n){
		word _16;
		ms->Read(&_16,2);
		int value = _16&mask_value;
		if(_16&0x8000){ // increasing sequence
			int length=(_16>>value_bits)&mask_length_inc;
			if(0==length) length=max_increse;
			for(int i=0;i<length;i++) mapping[ix++]=value++;
		}else{
			int length=(_16>>value_bits)&mask_length_rep;
			if(0==length) length=max_repeat;
			if(_16&0x4000){ // repeated value
				for(int i=0;i<length;i++) mapping[ix++]=value;
			}else{ // single value
				mapping[ix++]=value;
			}
		}
	}
}

void decodeblock(TMemoryStream* ms,int n,int si,word* ar,bool big) {
	int ix=0,m,i;
	byte ch; word ti;
	while(ix<n*si){
		ms->Read(&ch,1);
		if(ch&0x20){
			if((ch&0xC0)==0x00){
				m=ch-0x20; if(big){ ms->Read(&ch,1); m=m<<8|ch; }
				ms->Read(&ch,1); ti=ch<<8; ms->Read(&ch,1); ti+=ch;
				for(i=0;i<m;i++) ar[ix++]=ti;
			}else if((ch&0xC0)==0x40){
				m=ch-0x60; if(big){ ms->Read(&ch,1); m=m<<8|ch; }
				ms->Read(&ch,1); ti=ch<<8; ms->Read(&ch,1); ti+=ch;
				for(i=0;i<m;i++) ar[ix++]=ti++;
			}else if((ch&0xC0)==0x80){
				m=ch-0xA0;
				ar[ix++]=ar[ix-ix%si+m];
			}else if((ch&0xC0)==0xC0){
				m=ch-0xE0+0x20;
				ar[ix++]=ar[ix-ix%si+m];
			}
		}else{
			ti=ch<<8; ms->Read(&ch,1); ti+=ch; ar[ix++]=ti;
		}
	}
}

void decodetile16(TMemoryStream* ms,int n,byte* ar) {
	int ix=0,m,i;
	byte ch,ch2,ti[16],is[16]; word _16;
#define R(x) ms->Read(&(x),1);
#define RR(x) ms->Read(&(x),2);
#define I(x) for(i=0;i<(x);i++)
#define M1(x) if(m&1<<x)
#define M0(x) if(!(m&1<<x))
#define readallb I(16)R(ti[i]);
#define fillallb R(ch)I(16)ti[i]=ch;
#define fillall2b R(ch)R(ch2)I(8){ti[i*2]=ch;ti[i*2+1]=ch2;}
#define readallb2 I(8){R(ch);ti[i*2]=ti[i*2+1]=ch;}
#define fillb2 R(ch);m=ch;R(ch);I(8)M1(i){ti[i*2]=ti[i*2+1]=ch;is[i*2]=is[i*2+1]=true;}
#define readr2 I(8)if(!is[i*2]){R(ch);ti[i*2]=ti[i*2+1]=ch;}
#define fill2b R(ch);m=ch;R(ch)R(ch2)I(8)M1(i){ti[i*2]=ch;ti[i*2+1]=ch2;is[i*2]=is[i*2+1]=true;}
#define readr I(16)if(!is[i]){R(ti[i]);}
#define readallb_(O) I(8)R(ti[i*2+O]);
#define fillb_(O) R(ch);m=ch;R(ch);I(8)M1(i){ti[i*2+O]=ch;is[i*2+O]=true;}
#define readr_(O) I(8)if(!is[i*2+O]){R(ti[i*2+O]);}
#define readb RR(_16);m=_16;I(16)M0(i){R(ti[i]);is[i]=true;}
#define setr(x) I(16)if(!is[i]){ti[i]=x;}
#define rept RR(_16);I(16){ti[i]=ar[_16*16+i];}
#define read2b R(ch);m=ch;I(8)M0(i){R(ti[i*2]);R(ti[i*2+1]);is[i*2]=is[i*2+1]=true;}
	while(ix<n){
		ms->Read(&ch,1);
		for(i=0;i<16;i++)is[i]=false;
		switch(ch){
			case 0x00: readallb; break;
			case 0x01: fillallb; break;
			case 0x02: fillall2b; break;
			case 0x03: readallb2; break;
			case 0x04: fillb2; readr2; break;
			case 0x05: fillb2; fillb2; readr2; break;
			case 0x06: fill2b; readr; break;
			case 0x07: fill2b; fill2b; readr; break;
			case 0x08: fill2b; fill2b; fill2b; readr; break;
			case 0x09: fill2b; fill2b; fill2b; fill2b; /*readr;*/ break;
			case 0x0A: readallb_(0); fillb_(1); fillb_(1); readr_(1); break;
			case 0x0B: fillb_(0); readr_(0); fillb_(1); fillb_(1); readr_(1); break;
			case 0x0C: fillb_(0); fillb_(0); readr_(0); readr_(1); break;
			case 0x0D: fillb_(0); fillb_(0); readr_(0); fillb_(1); readr_(1); break;
			case 0x0E: fillb_(0); fillb_(0); readr_(0); fillb_(1); fillb_(1); readr_(1); break;
			//0x0F unused
			case 0x10: readb; setr(0x00); break;
			case 0x11: readb; setr(0x55); break;
			case 0x12: readb; setr(0xAA); break;
			case 0x13: readb; setr(0xFF); break;
			case 0x14: rept; read2b; break;
			default: throw Exception("error in decodetile16 : "+IntToStr((int)ch));
		}
		for(i=0;i<16;i++)ar[ix*16+i]=ti[i];
		ix++;
	}
}

void decodetile32(TMemoryStream* ms,int n,byte* ar) {
	int ix=0,m,i;
	byte ch,ch2,ch3,ch4,ti[32],is[32]; word _16;
#define readall_b I(32)R(ti[i]);
#define fillall_b R(ch)I(32)ti[i]=ch;
#define fillall4b R(ch)R(ch2)R(ch3)R(ch4)I(8){ti[i*2]=ch;ti[i*2+1]=ch2;ti[i*2+16]=ch3;ti[i*2+17]=ch4;}
#define fill4b R(ch);m=ch;R(ch)R(ch2)R(ch3)R(ch4)I(32)M1(i){ti[i*2]=ch;ti[i*2+1]=ch2;ti[i*2+16]=ch3;ti[i*2+17]=ch4;is[i*2]=is[i*2+1]=is[i*2+16]=is[i*2+17]=true;}
#define read4r I(8)if(!is[i*2]){R(ti[i*2]);R(ti[i*2+1]);R(ti[i*2+16]);R(ti[i*2+17]);}
#define read_vsp R(ch);m=ch;I(8)M1(i){R(ch);ti[i*2]=(ch&3)*0x55;ti[i*2+1]=(ch>>2&3)*0x55;ti[i*2+16]=(ch>>4&3)*0x55;ti[i*2+17]=(ch>>6&3)*0x55;}else{R(ti[i*2]);R(ti[i*2+1]);R(ti[i*2+16]);R(ti[i*2+17]);}
#define readb_(O) R(ch2);R(ch);m=ch;I(8)M0(i)R(ti[i*2+O])else ti[i*2+O]=ch2;
#define readball_(O) I(8)R(ti[i*2+O]);
#define rept_ R(ch);I(32){ti[i]=ar[ch*32+i];}
#define read_2b R(ch);m=ch;I(8)M0(i){R(ti[i*2]);R(ti[i*2+1]);R(ti[i*2+16]);R(ti[i*2+17]);is[i*2]=is[i*2+1]=is[i*2+16]=is[i*2+17]=true;}
//#define set_r(x) I(32)if(!is[i]){ti[i]=/*x*/0xFF;}
	while(ix<n){
		ms->Read(&ch,1);
		for(i=0;i<32;i++)is[i]=false;
		switch(ch){
			case 0x00: readall_b; break;
			case 0x01: fillall_b; break;
			case 0x02: fillall4b; break;
			case 0x03: fill4b; read4r; break;
			case 0x04: fill4b; fill4b; read4r; break;
			case 0x05: fill4b; fill4b; fill4b; read4r; break;
			case 0x06: fill4b; fill4b; fill4b; fill4b; read4r; break;
			//0x07 unused
			case 0x08: read_vsp; break;
			case 0x09: readb_(0); readball_(1); readball_(16); readball_(17); break;
			case 0x0A: readball_(0); readb_(1); readball_(16); readball_(17); break;
			case 0x0B: readb_(0); readb_(1); readball_(16); readball_(17); break;
			case 0x0C: readball_(0); readball_(1); readb_(16); readball_(17); break;
			case 0x0D: readb_(0); readball_(1); readb_(16); readball_(17); break;
			case 0x0E: readball_(0); readb_(1); readb_(16); readball_(17); break;
			case 0x0F: readb_(0); readb_(1); readb_(16); readball_(17); break;
			case 0x10: readball_(0); readball_(1); readball_(16); readb_(17); break;
			case 0x11: readb_(0); readball_(1); readball_(16); readb_(17); break;
			case 0x12: readball_(0); readb_(1); readball_(16); readb_(17); break;
			case 0x13: readb_(0); readb_(1); readball_(16); readb_(17); break;
			case 0x14: readball_(0); readball_(1); readb_(16); readb_(17); break;
			case 0x15: readb_(0); readball_(1); readb_(16); readb_(17); break;
			case 0x16: readball_(0); readb_(1); readb_(16); readb_(17); break;
			case 0x17: readb_(0); readb_(1); readb_(16); readb_(17); break;
			case 0x18: rept_; read_2b; /*set_r(0x00);*/ break;
			default: throw Exception("error in decodetile32 : "+IntToStr((int)ch));
		}
		for(i=0;i<32;i++)ar[ix*32+i]=ti[i];
		ix++;
	}
}
//---------------------------------------------------------------------------
void TSMC::drawroom(Graphics::TBitmap* dest_bitmap){
	int room=curr_room;
	// Black background
	dest_bitmap->Canvas->Brush->Color=pal[0];
	dest_bitmap->Canvas->FillRect(Rect(0,0,dest_bitmap->Width,dest_bitmap->Height));
	// Selection on empty background
	dest_bitmap->Canvas->Brush->Color=selected_pal[0];
	for(int row=0;row<3;row++){
		for(int column=0;column<10;column++){
			if(sel[row][column]) dest_bitmap->Canvas->FillRect(Rect(column*24,row*64,(column+1)*24,(row+1)*64));
		}
	}
	// Layers
	drawlayer(dest_bitmap, level.background[room], 3, 8, 16, bgblock, bgtile, NULL, 0x00, NULL);
	int room_left = level.room_links[room][0];
	// The room to the left ...
	if (room_left < 24) {
		// ... is an existing room
		for(int row=0;row<3;row++){
			drawblock(dest_bitmap, -24, row*64, level.block_fg[level.foreground[room_left][row][9]], 6, 8, 32, fgblock,fgtile, 0x60, false);
			draw_object(dest_bitmap, -24, row*64, level.block_object[level.foreground[room_left][row][9]], false);
		}
	} else {
		// ... is a non-existent room (e.g. 255)
		for(int row=0;row<3;row++){
			drawblock(dest_bitmap, -24, row*64, level.block_fg[255], 6, 8, 32, fgblock, fgtile, 0x60, false);
		}
	}
	drawlayer(dest_bitmap, level.foreground[room], 6, 8, 32, fgblock, fgtile, level.block_fg, 0x60, level.block_object);
	drawlayer(dest_bitmap, level.foreground[room], 3, 8, 32, ggblock, ggtile, level.block_gg, 0x20, NULL);

	dest_bitmap->Canvas->Brush->Color=clWhite;
	dest_bitmap->Canvas->Pen->Color=clBlack;
	// Object labels
	if(show_labels){
		for(int row=0;row<3;row++){
			for(int column=0;column<10;column++){
				int object=level.block_object[level.foreground[room][row][column]];
				if(object){
					if(object<COUNT(object_names)) dest_bitmap->Canvas->TextOutA(column*24,row*64,object_names[object]);
					else dest_bitmap->Canvas->TextOutA(column*24,row*64,IntToHex(object,2));
				}
				int modifier=level.modifiers[room][row][column];
				if(modifier) dest_bitmap->Canvas->TextOutA(column*24,row*64+32,IntToHex(modifier,2));
			}
		}
	}
	// Guards
	int guard_tilepos = level.guard_tilepos[room];
	if (guard_tilepos<30) {
		int row = guard_tilepos/10, column = guard_tilepos%10;
		int type = level.guard_type_dir[room];
		bool dir=type&0x80; type&=0x7F;
		if(show_labels){
			AnsiString s;
			if(type<COUNT(guard_names)) s=guard_names[type]; else s=IntToHex(type,2);
			if(dir) s="<"+s; else s=s+">";
			dest_bitmap->Canvas->TextOutA(column*24,row*64+16,s);
		}
		if(type>=2 && type<=19){
			int guard_palette = *(byte*)ROM_pointer(0x759E + type);
			int guard_sprite = *(word*)ROM_pointer(0xBF80 + (type<<1));
			if(guard_sprite==276) guard_sprite = -1; // shadow
			// The positions are correct for regular and fat guards, but slightly wrong for others.
			int x0=column*24+26;
			int y0=row*64+13;
			if (!dir) x0-=3;
			drawsprite(dest_bitmap, x0, y0, guard_sprite+15, guard_palette, !dir, sel[row][column]);
			x0+=17;
			y0+=23;
			if (dir) x0-=34;
			if (type != 8) { // shadow
				drawsprite(dest_bitmap, x0, y0, 208, 22, !dir,  sel[row][column]); // sword
			}
		}
	}
	// Kid start position
	if(room==level.start_room){
		int tilepos = level.start_tilepos;
		int row = tilepos/10, column = tilepos%10;
		if(show_labels) {
			dest_bitmap->Canvas->TextOutA(column*24, row*64+16, level.start_dir?"<start":"start>");
		}
		int kid_pal = 0;
		if(curr_level>=10-1 && curr_level<=12-1) kid_pal = 1; // red
		int x0=column*24+37;
		int y0=row*64+13;
		if (level.start_dir) x0-=25;
		drawsprite(dest_bitmap, x0, y0, 14, kid_pal, !level.start_dir, sel[row][column]);
	}
	// Wall and floor
	if (show_floors_walls) {
		for (int row=0;row<3;row++){
			for (int column=0;column<10;column++){
				int flags = get_block_flags(level.foreground[room][row][column]);
				draw_floor_wall(dest_bitmap, column*24, row*64, flags);
			}
		}
	}
}

void TSMC::draw_floor_wall(Graphics::TBitmap* dest_bitmap, int x0, int y0, int flags) {
	if (flags & 1) {
		// floor
		dest_bitmap->Canvas->Brush->Color = clLtGray;
		dest_bitmap->Canvas->FrameRect(Rect(x0+1, y0+55, x0+23, y0+63));
	}
	if (flags & 2) {
		// wall
		dest_bitmap->Canvas->Brush->Color = clLtGray;
		dest_bitmap->Canvas->FrameRect(Rect(x0+1, y0+1, x0+23, y0+63));
	}
}
//---------------------------------------------------------------------------
void TSMC::drawlayer(Graphics::TBitmap* dest_bitmap, byte layer_data[3][10], int block_width, int block_height, int tile_size, word* block, byte* tile, byte* xlat, byte pal_offset0, byte* xlat_object){
	for (int row=0;row<3;row++) {
		for (int column=0;column<10;column++) {
			byte x = layer_data[row][column];
			drawblock(dest_bitmap, column*24, row*64, xlat?xlat[x]:x, block_width, block_height, tile_size, block, tile, pal_offset0, sel[row][column]);
			if (NULL != xlat_object) draw_object(dest_bitmap, column*24, row*64, xlat_object[x], sel[row][column]);
		}
	}
}
//---------------------------------------------------------------------------
void TSMC::drawblock(Graphics::TBitmap* dest_bitmap, int x0, int y0, int block_index, int block_width, int block_height, int tile_size, word* blocks, byte* tiles, byte pal_offset0, bool sel){
	word* block_tile_pos = &blocks[block_index*block_width*block_height];
	for(int y=0;y<block_height;y++){
		for(int x=0;x<block_width;x++){
			drawtile(dest_bitmap, x0+x*8, y0+y*8, *block_tile_pos, tile_size, tiles, pal_offset0, sel);
			++block_tile_pos;
		}
	}
}
//---------------------------------------------------------------------------
void TSMC::drawtile(Graphics::TBitmap* dest_bitmap, int x0, int y0, int tile_info, int tile_size, byte* tiles, byte pal_offset0, bool selected) {
	int flip_x = tile_info & 0x4000 ? 7 : 0; // bit 14
	int flip_y = tile_info & 0x8000 ? 7 : 0; // bit 15
	int pal_offset = pal_offset0 + ((tile_info>>10&7)<<(tile_size>>3)); // bits 10..12
	int tile_index = tile_info & 0x3FF; // bits 0..9
	int n_planes_high = tile_size >> 4;
	byte pixels[8][8];
	memset(pixels, 0, sizeof(pixels));
	// Convert tile from planar to sequential.
	byte* tile_base = &tiles[tile_index*tile_size];
	for (int plane_high=0;plane_high<n_planes_high;plane_high++) {
		for (int plane_low=0;plane_low<2;plane_low++) {
			byte color = 1<<((plane_high<<1)+plane_low);
			byte* plane_base = &tile_base[(plane_high<<4)+plane_low];
			for (int y=0;y<8;y++){
				for (int x=0;x<8;x++){
					if (plane_base[(y<<1)] & 128>>x) {
						pixels[y][x] |= color;
					}
				}
			}
		}
	}
	// Draw tile to dest_bitmap, skipping transparent pixels, and flipping if needed.
	for (int y=0;y<8;y++) {
		for (int x=0;x<8;x++) {
			if (pixels[y][x]) {
				dest_bitmap->Canvas->Pixels[x0+(x^flip_x)][y0+(y^flip_y)] = (selected?selected_pal:pal)[pixels[y][x] + pal_offset];
			}
		}
	}
}
//---------------------------------------------------------------------------
void decode_palette(TMemoryStream* ms, TColor*& palette, int count) {
	// Convert palette from SNES format to RGB.
	palette = new TColor[count];
	for(int i=0;i<count;i++){
		word color;
		ms->Read(&color,2);
		palette[i] = (TColor)(RGB(color&0x1F, color>>5&0x1F, color>>10&0x1F) << 3);
	}
}
//---------------------------------------------------------------------------
void create_selected_palette(TColor* palette, TColor* selected_palette, int count){
	// Create the palette of selected things.
	for(int i=0;i<count;i++) {
		// A color halfway between white and the original color.
		selected_palette[i] = (TColor)((palette[i]>>1)|0x808080);
	}
}
//---------------------------------------------------------------------------
void TSMC::clear_selection(){
	int i,j;
	for(i=0;i<3;i++) for(j=0;j<10;j++) sel[i][j]=false;
}
//---------------------------------------------------------------------------
void compress_level_part(TMemoryStream* ms_in, TMemoryStream* ms_out, int length);

void TSMC::savelevel(){
	int ix=curr_level;
	TMemoryStream* ms_level_compressed = ms_data[41+ix];
	TMemoryStream* ms_level = new TMemoryStream;
	ms_level_compressed->Clear();
	ms_level->Write(&level,sizeof(TLevel));
	ms_level->Position=0;
	compress_level_part(ms_level, ms_level_compressed, 720); // background
	compress_level_part(ms_level, ms_level_compressed, 720); // foreground
	compress_level_part(ms_level, ms_level_compressed, 720); // modifiers
	compress_level_part(ms_level, ms_level_compressed, 256); // block_gg
	compress_level_part(ms_level, ms_level_compressed, 256); // block_fg
	compress_level_part(ms_level, ms_level_compressed, 256); // block_object
	compress_level_part(ms_level, ms_level_compressed, 256); // block_flags_back_anim
	compress_level_part(ms_level, ms_level_compressed, 244); // ...
	compress_level_part(ms_level, ms_level_compressed, 256); // door_events_1
	compress_level_part(ms_level, ms_level_compressed, 256); // door_events_2
//	ms_level->SaveToFile("dumplv");
//	ms_level_compressed->SaveToFile("dumplvcmp");
	delete ms_level;
}

void compress_level_part(TMemoryStream* ms_in, TMemoryStream* ms_out, int length) {
	int start_offset = ms_in->Position;
	int end_offset = start_offset + length;
	byte *start_pos = (byte*)ms_in->Memory + start_offset;
	byte *input_pos = start_pos;
	byte *end_pos = (byte*)ms_in->Memory + end_offset;
	byte raw_length = 0, raw_data[128];
	while(input_pos<end_pos){
		// Determine how many bytes can we compress with each compression type.
		int length, copy_start_address;
		int length_with_method[5];
		for(int i=0;i<5;i++) length_with_method[i]=0;
		// 1: sequence of identical bytes
		for(length=0; input_pos+length+1<end_pos && length<256; length++) {
			if(*(input_pos+length)   != *(input_pos+length+1)) break;
		}
		if(length>3) length_with_method[1]=length;
		// 2: sequence of increasing bytes
		for(length=0; input_pos+length+1<end_pos && length<256; length++) {
			if(*(input_pos+length)+1 != *(input_pos+length+1)) break;
		}
		if(length>3) length_with_method[2]=length;
		// 3: sequence of decreasing bytes
		for(length=0; input_pos+length+1<end_pos && length<256; length++) {
			if(*(input_pos+length)-1 != *(input_pos+length+1)) break;
		}
		if(length>3) length_with_method[3]=length;
		// 4,5: copy of some previous bytes
		length_with_method[4]=0;
		for(byte* copy_pos=start_pos; copy_pos<input_pos; copy_pos++){
			for(length=0; length<256 && input_pos+length<end_pos; length++){
				if(*(input_pos+length)!=*(copy_pos+length)) break;
			}
			//length++;
			if (length>length_with_method[4] && (length>4 || copy_pos-start_pos<0xFF && length>3)) {
				copy_start_address=copy_pos-start_pos; length_with_method[4]=length;
			}
		}
		// Find best compression type for next bytes.
		int best_length=0, best_type=0;
		for (int i=1;i<=4;i++) {
			if (length_with_method[i] > best_length) {
				best_length = length_with_method[i]; best_type = i;
			}
		}
		if (best_length < 2) {
			raw_data[raw_length++]=*(input_pos++);
			if(raw_length==0x7F){
				raw_length+=0x80; ms_out->Write(&raw_length,1); raw_length-=0x80;
				ms_out->Write(raw_data,raw_length); raw_length=0;
			}
		} else {
			if(raw_length){
				raw_length+=0x80; ms_out->Write(&raw_length,1); raw_length-=0x80;
				ms_out->Write(raw_data,raw_length); raw_length=0;
			}
			if(best_type==4){
				if(copy_start_address>=0x100){
					best_type=5; ms_out->Write(&best_type,1); ms_out->Write(&best_length,1); ms_out->Write(&copy_start_address,2);
				}else{
					ms_out->Write(&best_type,1); ms_out->Write(&best_length,1); ms_out->Write(&copy_start_address,1);
				}
			}else{
				ms_out->Write(&best_type,1);
				ms_out->Write(&best_length,1);
				ms_out->Write(input_pos,1);
			}
			input_pos += best_length;
		}
	}
	if(raw_length){
		raw_length+=0x80; ms_out->Write(&raw_length,1); raw_length-=0x80;
		ms_out->Write(raw_data,raw_length); raw_length=0;
	}
//	ShowMessage(input_pos-end_pos);
	ms_in->Position=end_offset;
}
//---------------------------------------------------------------------------
void TSMC::savesmc(AnsiString filename){
	unsigned __int32 sa[93];
	ms_smc->Position=0x20000+SMCHD;
	sa[0]=0x20000+ndata*3;
	for(int i=1;i<ndata;i++){
		sa[i]=sa[i-1]+ms_data[i-1]->Size;
		// If the resources don't fit into the first area:
		if(sa[i]<=0x78000 && sa[i]+ms_data[i]->Size>0x78000){
			memset((char*)ms_smc->Memory + sa[i]+SMCHD, 0, 0x78000-sa[i]); // zero-fill end of first area
			sa[i]=0xE0A00; // second area, after sprites
		}
		if(sa[i]>=0xE8000) throw Exception("Data doesn't fit into its place!");
	}
//	if(sa[91]>lastsa) return ShowMessage("error in savesmc : level too big");
//	sa[91]=lastsa;
	for(int i=0;i<ndata;i++){
		word of; byte bank;
		of=(sa[i]&0x7FFF)|0x8000; bank=sa[i]>>15;
		ms_smc->Write(&of,2); ms_smc->Write(&bank,1);
	}
	for(int i=0;i<ndata-1;i++){
		ms_smc->Position = sa[i]+SMCHD;
		ms_smc->CopyFrom(ms_data[i],0);
	}
	ms_data[ndata-1]->Position=0;
	ms_smc->Position = sa[ndata-1]+SMCHD;
	int end = sa[ndata-1]>0x78000 ? 0xE8000 : 0x78000;
	int remain_len = end+SMCHD-ms_smc->Position;
	int lastsize = ms_data[ndata-1]->Size;
	if(remain_len < ms_data[ndata-1]->Size){
		byte* ptr = (byte*)ms_data[ndata-1]->Memory;
		int datasize = ms_data[ndata-1]->Size;
		bool bad = false;
		for(int i = remain_len; i < datasize && !bad; i++){
			if(ptr[i]!=0) bad=true;
		}
		if (bad) {
			if (MessageBoxA(NULL,"Last resource doesn't fit into its place! Do you still want to save?","Warning",MB_YESNO|MB_ICONWARNING) != IDYES) {
				throw Exception("Last resource doesn't fit into its place!");
			}
		}
	}
	int copy_len = remain_len;
	if(remain_len > lastsize) copy_len = lastsize;
	ms_smc->CopyFrom(ms_data[ndata-1],copy_len);
	if(remain_len > lastsize){
		int pos = ms_smc->Position;
		char* mem = (char*)ms_smc->Memory;
		memset(mem + pos, 0, remain_len - lastsize);
	}
	ms_smc->SaveToFile(filename);
}
//---------------------------------------------------------------------------
void decodesprite(TMemoryStream* ms_in, byte*& tiles, byte& width_block, byte& height_block, byte& width_pixel, byte& height_pixel) {
	static byte const plane_offsets[]={0x00,0x01,0x10,0x11,0x20,0x21,0x30,0x31};
	ms_in->Read(&width_pixel,1);
	ms_in->Read(&height_pixel,1);
	{
		byte size;
		ms_in->Read(&size,1);
		height_block = size>>4;
		width_block = size&15;
	}
	tiles = new byte[width_block*height_block*128];
	byte* tile_pos = tiles;
	for(int i=0;i<width_block*height_block*2;i++){
		byte layers_mask;
		ms_in->Read(&layers_mask,1);
		byte tile[64];
		memset(tile,0,64);
		for(int plane=0;plane<8;plane++){
			if(!(layers_mask&1<<plane)) continue;
			byte plane_offset=plane_offsets[plane];
			bool fill = false;
			byte rows_mask;
			ms_in->Read(&rows_mask,1); if(rows_mask==255){ms_in->Read(&rows_mask,1);fill=true;}
			if(fill){ // fill
				byte fill_value;
				ms_in->Read(&fill_value,1);
				for(int y=0;y<8;y++){
					if(!(rows_mask&1<<y)) tile[(y<<1)+plane_offset] = fill_value;
				}
			}else{ // copy
				for(int y=0;y<8;y++){
					if(!(rows_mask&1<<y)) ms_in->Read(&(tile[(y<<1)+plane_offset]),1);
				}
			}
		}
		memcpy(tile_pos,tile,64);
		tile_pos += 64;
	}
}

void TSMC::drawsprite(Graphics::TBitmap* dest_bitmap, int x0, int y0, int sprite_index, int palette_index, bool flip, bool selected) {
	// Find sprite in ROM.
	{
		word of; byte bank;
		int sa; 
		ms_smc->Position=0x78000+SMCHD+sprite_index*3;
		ms_smc->Read(&of,2);
		ms_smc->Read(&bank,1);
		sa=(bank<<15)|(of&0x7FFF);
		ms_smc->Position=sa+SMCHD;
	}
	// Decode sprite.
	byte width_block, height_block, width_pixel, height_pixel;
	byte* tiles;
	decodesprite(ms_smc, tiles, width_block, height_block, width_pixel, height_pixel);
	// Load sprite's palette into global palette.
	{
		ms_data[68]->Position = palette_index<<5;
		TColor* sprite_palette;
		decode_palette(ms_data[68], sprite_palette, 16);
		memcpy(pal+128, sprite_palette, 16*sizeof(TColor));
		create_selected_palette(pal, selected_pal, 256);
		delete[]sprite_palette;
	}
	// Draw sprite.
	int tile_index=0;
	// 1 block = 2x2 tiles
	for(int y_block=0;y_block<height_block;y_block++){
		for(int x_block=0;x_block<width_block;x_block++){
			for(int y_tile=0;y_tile<2;y_tile++){
				for(int x_tile=0;x_tile<2;x_tile++){
					if(flip){
						drawtile(dest_bitmap, x0/*+width_pixel*/-(x_block<<4)-(x_tile<<3)-8, y0+(y_block<<4)+(y_tile<<3), tile_index^0x4000, 32, tiles, 0x80, selected);
					}else{
						drawtile(dest_bitmap, x0+(x_block<<4)+(x_tile<<3), y0+(y_block<<4)+(y_tile<<3), tile_index, 32, tiles, 0x80, selected);
					}
					tile_index++;
				}
			}
		}
	}
	delete[]tiles;
}
//---------------------------------------------------------------------------
void decode_background_sprite(TMemoryStream* ms_in, byte*& tiles){
	// Background sprites have a fixed size of width=6 tiles, height=8 tiles=64 pixels.
	static const int width_tiles = 6, height_pixels = 64, n_planes = 4;
	static byte const plane_offsets[]={0x00,0x01,0x10,0x11,0x20,0x21,0x30,0x31};
	word column_address[width_tiles];
	int sprite_start_address = ms_in->Position;
	tiles = new byte[width_tiles*n_planes*height_pixels];
	memset(tiles,0,width_tiles*n_planes*height_pixels);
	for (int x_tile=0;x_tile<width_tiles;x_tile++) {
		ms_in->Read(&column_address[x_tile],2);
	}
	for (int x_tile=0;x_tile<width_tiles;x_tile++) {
		if (0 == column_address[x_tile]) continue;
		byte* column_base = &tiles[x_tile*n_planes*height_pixels];
		ms_in->Position = sprite_start_address + column_address[x_tile];
		for (int y_pixel=0;y_pixel<height_pixels;) {
			byte ch;
			ms_in->Read(&ch,1);
			if(ch>>7){ // skip
				y_pixel+=ch&0x7F;
			}else{ // copy
				for(int j=0;j<ch;j++){
					byte* row_base = &column_base[(y_pixel>>3<<5)+((y_pixel&7)<<1)];
					byte mask, layer_bytes[n_planes];
					ms_in->Read(&mask,1); // An additional plane for transparency.
					ms_in->Read(&layer_bytes,n_planes);
					for(int plane=0;plane<n_planes;plane++){
						row_base[plane_offsets[plane]] = layer_bytes[plane];
					}
					y_pixel++;
				}
			}
		}
	}
}

void TSMC::draw_background_sprite(Graphics::TBitmap* bm, int x0, int y0, int sprite_index, bool sel){
	{
		ms_smc->Position=0x78000+SMCHD+sprite_index*3;
		word of; byte bank;
		ms_smc->Read(&of,2);
		ms_smc->Read(&bank,1);
		int sa=(bank<<15)|(of&0x7FFF);
		ms_smc->Position=sa+SMCHD;
	}
	byte* tile;
	decode_background_sprite(ms_smc, tile);
	int ti=0;
	for(int x=0;x<6;x++){
		for(int y=0;y<8;y++){
			drawtile(bm,x0+(x<<3),y0+(y<<3),ti++,32,tile,0x60,sel);
		}
	}
	delete[]tile;
}
//---------------------------------------------------------------------------
void TSMC::draw_object(Graphics::TBitmap* bm, int x0, int y0, byte object_type, bool sel){
	//int lt=level_type; if(lt==9) lt=6;
	int lt=object_level_type;
/*	int T0Bx[]={31,28,28,28,28,28,31,32,31,31};
	int T1Dx[]={23, 8,32, 0,36,28,29,23,23,23};
	int T21x[]={23, 8, 2, 0,36,28,37,23,23,23};
	int T22x[]={23, 8,32, 0,36,36,36,23,23,23};

	int T0By[]={ 1, 0, 0, 0, 0, 0,-7,-16, 0, 0};
	int T1Dy[]={ 0, 0, 0, 0, 0,-8,-8, 0, 0, 0};
	int T21y[]={ 0, 0, 2, 0, 0,16,-8, 0, 0, 0};
	int T22y[]={ 0, 0, 0, 0, 0,-8, 0, 0, 0, 0};*/
	int torch_addr=*(word*)ROM_pointer(0xC54E+2*curr_level);
	int T0Bx=*(signed char*)ROM_pointer(torch_addr+0);
	int T0By=*(signed char*)ROM_pointer(torch_addr+1);
	int T1Dx=*(signed char*)ROM_pointer(torch_addr+2);
	int T1Dy=*(signed char*)ROM_pointer(torch_addr+3);
	int T21x=*(signed char*)ROM_pointer(torch_addr+4);
	int T21y=*(signed char*)ROM_pointer(torch_addr+5);
	int T22x=*(signed char*)ROM_pointer(torch_addr+6);
	int T22y=*(signed char*)ROM_pointer(torch_addr+7);

	if(lt==4&&curr_level==14&&(curr_room==15||curr_room==18)&&
		(object_type==0x02||object_type==0x04||object_type==0x05||object_type==0x17)) lt=7; // blue
	switch(object_type){
		case 0x02: // loose floor
		draw_background_sprite(bm,x0,y0,1252+lt*6,sel);
		break;
		case 0x04: // door opener
		draw_background_sprite(bm,x0,y0,1250+lt*6,sel);
		break;
		case 0x05: // door closer
		draw_background_sprite(bm,x0,y0,1251+lt*6,sel);
		break;
		case 0x06: // door
		draw_background_sprite(bm,x0,y0,1359,sel);
		break;
		case 0x07: // level door (end)
		draw_background_sprite(bm,x0,y0-16,1297+lt,sel);
		break;
		case 0x08: // mirror
		draw_background_sprite(bm,x0,y0,1370,sel);
		break;
		case 0x09: // skeleton
		draw_background_sprite(bm,x0,y0,1371,sel);
		break;
		case 0x0A: // sword
		drawsprite(bm,x0,y0+50,697,22,false,sel);
		break;
		case 0x0B: // torch
		drawtorch(bm,x0+T0Bx,y0+T0By,sel);
		break;
		case 0x0C: // chomper
		draw_background_sprite(bm,x0,y0,1308,sel);
		break;
		case 0x0D: // guillotine
		draw_background_sprite(bm,x0,y0,1315,sel);
		break;
		case 0x0E: // spike
		draw_background_sprite(bm,x0,y0,1345,sel);
		break;
		case 0x10: // crusher
		draw_background_sprite(bm,x0,y0,1373,sel);
		break;
		case 0x12: // heal potion
		drawsprite(bm,x0+16,y0+38,1089,24,false,sel);
		break;
		case 0x13: // life potion
		drawsprite(bm,x0+16,y0+40,1088,24,false,sel);
		break;
		case 0x14: // hurt potion
		drawsprite(bm,x0+16,y0+38,1093,24,false,sel);
		break;
		case 0x15: // upside down potion
		drawsprite(bm,x0+16,y0+40,1088,24,false,sel);
		break;
		case 0x16: // slow fall potion
		drawsprite(bm,x0+16,y0+40,1088,24,false,sel);
		break;
		case 0x17: // debris
		draw_background_sprite(bm,x0,y0,1254+lt*6,sel);
		break;
		case 0x19: // fire
		draw_background_sprite(bm,x0,y0,1386,sel);
		break;
		case 0x1A: // potion of warp
		drawsprite(bm,x0+16,y0+40,1088,24,false,sel);
		break;
		case 0x1C: // kill potion
		drawsprite(bm,x0+16,y0+40,1088,24,false,sel);
		break;
		case 0x1D: // torch
		drawtorch(bm,x0+T1Dx,y0+T1Dy,sel);
		break;
		case 0x1E: // log
		draw_background_sprite(bm,x0,y0,1336,sel);
		break;
		case 0x20: // stars
		draw_background_sprite(bm,x0,y0,1348,sel);
		break;
		case 0x21: // torch
		drawtorch(bm,x0+T21x,y0+T21y,sel);
		break;
		case 0x22: // torch
		drawtorch(bm,x0+T22x,y0+T22y,sel);
		break;
		case 0x24: // level door (begin)
		draw_background_sprite(bm,x0,y0-16,1297+lt,sel);
		break;
		case 0x2A: // conveyor belt >>>
		draw_background_sprite(bm,x0,y0,1388,sel);
		break;
		case 0x2B: // conveyor belt <<<
		draw_background_sprite(bm,x0,y0,1388,sel);
		break;
	}
}
//---------------------------------------------------------------------------
void TSMC::drawtorch(Graphics::TBitmap* bm,int x0,int y0,bool sel){
/*
	TColor* mypal;
	ms_data[68]->Position=23<<5;
	decode_palette(ms_data[68],mypal,16);
	memcpy(pal+128,mypal,16*sizeof(TColor));
	create_selected_palette(pal,selected_pal,256);
	delete[]mypal;
	drawtile(bm,x0,y0,0,32,(byte*)ms_data[73]->Memory,0x80,sel);
	drawtile(bm,x0,y0+8,1,32,(byte*)ms_data[73]->Memory,0x80,sel);
*/
	Graphics::TBitmap* bm_torch = new Graphics::TBitmap();
	bm_torch->Width = 8;
	bm_torch->Height = 16;
	bm_torch->Canvas->Brush->Color = clWhite;
	bm_torch->Canvas->FillRect(Rect(0,0,8,16));
	bm_torch->Transparent = true;
	bm_torch->TransparentMode = tmFixed;
	bm_torch->TransparentColor = clWhite;
	drawsprite(bm_torch,0,0,1087,23,false,sel);

	bm->Canvas->Draw(x0,y0,bm_torch);
	
	delete bm_torch;
}
//---------------------------------------------------------------------------
void* TSMC::ROM_pointer(int addr){
	return (char*)ms_smc->Memory+SMCHD+addr;
}
//---------------------------------------------------------------------------
void TSMC::set_level_type(int level_number, int new_level_type){
	level_type=new_level_type;
	*(char*)ROM_pointer(0x36EE + level_number)=new_level_type;

	int new_object_level_type = new_level_type;
	if(new_level_type==9) new_object_level_type=6;
	//*((char*)smc.ms_smc->Memory+0xED08+SMCHD+level)=smc.object_level_type=new_object_level_type;
	object_level_type=new_object_level_type;
	*(char*)ROM_pointer(0xED08 + level_number)=new_object_level_type;
	open_level_graphics(new_level_type);
	
	// Set offscreen walls based on level type.
	const static char wall_fg[10]={0x06,0x04,0x18,0x0D,0x04,0x0A,0x05,0x00,0x00,0x05};
	const static char wall_gg[10]={0x01,0x02,0x2B,0x2A,0xFF,0x01,0x0F,0x00,0x00,0x0F};
	level.block_fg[255]=wall_fg[new_level_type];
	level.block_gg[255]=wall_gg[new_level_type];
	level.block_object[255]=0;
	level.block_flags_back_anim[255]=2;
	
	const static word torch_pl[10]={0xC584,0xC58C,0xC594,0xC59C,0xC5A4,0xC5AC,0xC5B4,0xC5BC,0xC5BC,0xC5B4};
	*(word*)ROM_pointer(0xC54E+2*curr_level)=torch_pl[new_level_type];
}
//---------------------------------------------------------------------------
void TSMC::editenvpal(){
	static const char* descriptions[]={
		"0: layer 1",
		"1: layer 1",
		"2: layer 3",
		"3: layer 3",
		"4: layer 3",
		"5: (empty)",
		"6: layer 2, background sprites",
		"7: overwritten by hitpoint palette",
		NULL
	};
	editpal(level_type*4+4,"environment",descriptions);
	open_level_graphics(level_type);
}
//---------------------------------------------------------------------------
void encode_palette(TMemoryStream* ms,TColor*pal,int ln);

void TSMC::editpal(int index, AnsiString title, const char** descriptions) {
	std::vector<TColor> pal;
	TMemoryStream* ms_pal=NULL;
	if (index == -1) { // "hardcoded" palette
		ms_pal=new TMemoryStream();
		ms_smc->Position = 0x2130 + SMCHD;
		ms_pal->CopyFrom(ms_smc,256*2);
	} else {
		ms_pal=ms_data[index];
	}
	int n=ms_pal->Size>>1;
	pal.resize(n);
	ms_pal->Seek(0,soFromBeginning);
	TColor* temp;
	decode_palette(ms_pal,temp,n);
	for(int i=0;i<n;i++) pal[i]=temp[i];
	delete[]temp;
	TPaletteEditForm* paled=new TPaletteEditForm(Application);
	paled->Caption="Editing "+title+" palette";
	bool r=paled->edit(pal,descriptions);
	delete paled;
	if(!r) return;
	ms_pal->Seek(0,soFromBeginning);
	encode_palette(ms_pal,&(pal[0]),n);
	if (index == -1) { // "hardcoded" palette
		ms_smc->Position = 0x2130 + SMCHD;
		ms_pal->Position = 0;
		ms_smc->CopyFrom(ms_pal,256*2);
		delete ms_pal;
	}
}
//---------------------------------------------------------------------------
void encode_palette(TMemoryStream* ms,TColor*pal,int ln) {
	for(int i=0;i<ln;i++){
		TColor c = (TColor)((pal[i]&0xF8F8F8)>>3);
		word _16 = GetRValue(c) | GetGValue(c)<<5 | GetBValue(c)<<10;
		ms->Write(&_16,2);
	}
}
//---------------------------------------------------------------------------
void TSMC::editspritespal(){
	static const char* descriptions[]={
		" 0: kid",
		" 1: red kid",
		" 2: slowfall kid",
		" 3: princess",
		" 4: skeleton",
		" 5: brown skeleton",
		" 6: gold skeleton",
		" 7: skeleton on level 10",
		" 8: amazon",
		" 9: fat",
		"10: shadow",
		"11: yellow guard",
		"12: green guard",
		"13: blue guard",
		"14: red guard",
		"15: purple guard",
		"16: blueface guard",
		"17: red knight",
		"18: blue knight",
		"19: monster",
		"20: Jaffar",
		"21: mouse",
		"22: sword",
		"23: prince fire, flame, hardhit",
		"24: potion",
		"25: elephant",
		"26: ?",
		NULL
	};
	editpal(68,"sprites",descriptions);
}
//---------------------------------------------------------------------------
void TSMC::editscrnpal(){
	static const char* descriptions[]={
		" 0: hitpoint",
		" 1: princess room top part",
		" 2: princess room front arches",
		" 3: princess room where the wall meets the floor",
		" 4: princess room floor",
		" 5: princess room hourglass",
		" 6: Masiya logo, pegasus",
		" 7: Masiya logo stars?",
		" 8: title",
		" 9: game name",
		"10",
		"11",
		"12: main menu background",
		"13: where Jaffar walks front curtain",
		"14: where Jaffar walks floor/column/statue/flag gradient",
		"15: where Jaffar walks back layer",
		"16: ending brown",
		"17: ending sundown",
		"18",
		"19: torture front layer",
		"20: torture back layer",
		"21: torture guards",
		"22: garden back and front layer + fountain water",
		"23: garden back layer guard",
		"24: garden front layer guard",
		"25: garden",
		"26: Konami logo letters",
		"27: Konami logo logo top left",
		"28: Konami logo logo bottom right",
		"29: Konami logo line and stars",
		"30: Konami logo grey letters",
		"31: Konami logo yellow logo top left",
		"32: Konami logo orange logo bottom right",
		NULL
	};
	editpal(69,"screens",descriptions);
}
//---------------------------------------------------------------------------
void TSMC::edithcpal(){
	static const char* descriptions[]={
		" 0",
		" 1: the last 3 colors of this row are used",
		" 2",
		" 3",
		" 4",
		" 5",
		" 6",
		" 7",
		" 8",
		" 9",
		"10",
		"11",
		"12",
		"13",
		"14",
		"15",
		NULL
	};
	editpal(-1,"hardcoded",descriptions);
}
//---------------------------------------------------------------------------
void TSMC::editlevelgr(int layer){
	TLevelGraphicsEditForm* lf=new TLevelGraphicsEditForm(Application);
	switch(layer){
		case 1: lf->edit_graphics(this,3,8,16,bgblock,bgtile,0,512); break;
		case 2: lf->edit_graphics(this,6,8,32,fgblock,fgtile,0x60,256); break;
		case 3: lf->edit_graphics(this,3,8,32,ggblock,ggtile,0x20,256); break;
	}
	delete lf;
	if(layer>=1&&layer<=3) gr_edited[layer-1]=true;
}
//---------------------------------------------------------------------------
void TSMC::encodeenv(TMemoryStream* ms_out,word**block,byte**tile,
		int wh, int hh, int si, int n_block, int n_tile, int Bib, int Bit, TMemoryStream* rest) {
	ms_out->Clear();
//	ms_out->Write(&nb,2);
	//word* mapping=NULL;
	vector<word> mapping;
	TMemoryStream* new_bl;
	determine_array(n_block,wh*hh*2,(char*)*block,new_bl,mapping,Bib);
	int n_new_block=new_bl->Size/(wh*hh*2);
	ms_out->Write(&n_new_block,2);
//	word _16;
//	_16=nb<<Bib|0x8000;
//	ms_out->Write(&_16,2);
	//ms_out->Write(mapping,n_block*2);
	ms_out->Write(&(mapping[0]),mapping.size()*2);
	//delete[]mapping;
//	encodearray(ms_out,nb,Bib,ar);
	int n=n_new_block;
	word* bl=(word*)new_bl->Memory;
	bool big=wh==6;
	encodeblocks(ms_out,n,wh*hh,bl,big);
	delete new_bl;
	ms_out->CopyFrom(rest,0);
/*
	ms_out->Write(&nt,2);
//	encodearray(ms_out,nt,Bit,ar);
	_16=nt<<Bit|0x8000;
	ms_out->Write(&_16,2);
	n=nt;
	byte*ti=*tile;
	if(si==16) encodetile16(ms_out,n,ti);
	if(si==32) encodetile32(ms_out,n,ti);
	ms_out->Write(&nt,2);
*/
}
//---------------------------------------------------------------------------
void TSMC::determine_array(int n,int si,char* items,TMemoryStream*& ms_new_items,vector<word> & out_mapping, int bits){
	char* new_items=new char[n*si];
	word* unc_mapping=new word[n];
	int nn=0;
	for(int i=0;i<n;i++){
		int j;
		for(j=0;j<nn;j++){
			if(memcmp(items+i*si,new_items+j*si,si)==0) break;
		}
		if(j==nn){
			nn++;
			memcpy(new_items+j*si,items+i*si,si);
		}
		unc_mapping[i]=j;
	}
	ms_new_items=new TMemoryStream();
	ms_new_items->Write(new_items,nn*si);
	{
		int max_inc = 1<<(16-bits-1);
		int max_rep = 1<<(16-bits-2);
		int nm = (1<<bits)-1;
		int outptr = 0;
		//word * out = new word[n];
		out_mapping.resize(n);
		for(int i=0;i<n;){
			int j=i; int c;
			if(i+1<n && unc_mapping[i]+1==unc_mapping[i+1]){
				c=1;
				while(j+1<n && unc_mapping[j]+1==unc_mapping[j+1] && c<max_inc){
					j++; c++;
				}
				out_mapping[outptr]=0x8000|c<<bits|unc_mapping[i]&nm; outptr++;
				i=j+1;
			}else{
				c=0;
				while(j<n && unc_mapping[j]==unc_mapping[i] && c<max_rep){
					j++; c++;
				}
				out_mapping[outptr]=0x4000|c<<bits|unc_mapping[i]&nm; outptr++;
				i=j;
			}
		}
		delete[]unc_mapping;
		out_mapping.resize(outptr);
		//memcpy();
		//mapping = out;
	}
}
//---------------------------------------------------------------------------
void TSMC::encodeblocks(TMemoryStream* ms,int n,int si,word* ar,bool big){
	for(int i=0;i<n;i++){
		//ms->Write((char*)(ar+i)+1,1);
		//ms->Write(ar+i,1);
		encodeblock(ms,si,ar+i*si,big);
	}
}
//---------------------------------------------------------------------------
void TSMC::encodeblock(TMemoryStream* ms,int si,word* ar,bool big){
	int lim=big?0x1FFF:0x1F;
	for(int i=0;i<si;){
		if(i+1<si && ar[i]==ar[i+1]){
			int c=1,j=i;
			while(j+1<si && ar[j]==ar[j+1] && c+1<lim){
				j++; c++;
			}
			if(big){
				char ch=c>>8|0x20;
				ms->Write(&ch,1);
				ms->Write(&c,1);
			}else{
				char ch=c|0x20;
				ms->Write(&ch,1);
			}
			j++;
			ms->Write((char*)(ar+i)+1,1);
			ms->Write(ar+i,1);
			i=j;
		}else if(i+1<si && ar[i]+1==ar[i+1]){
			int c=1,j=i;
			while(j+1<si && ar[j]+1==ar[j+1] && c+1<lim){
				j++; c++;
			}
			j++;
			if(big){
				char ch=c>>8|0x60;
				ms->Write(&ch,1);
				ms->Write(&c,1);
			}else{
				char ch=c|0x60;
				ms->Write(&ch,1);
			}
			ms->Write((char*)(ar+i)+1,1);
			ms->Write(ar+i,1);
			i=j;
		}else{
			int j; bool l=false;
			for(j=0;j<i && j<0x20;j++) if(ar[j]==ar[i]){ l=true; break; }
			if(l){
				char ch=j|0xA0;
				ms->Write(&ch,1);
			}else{
				ms->Write((char*)(ar+i)+1,1);
				ms->Write(ar+i,1);
			}
			i++;
		}
	}
}
//---------------------------------------------------------------------------
/*void TSMC::encodetile16(TMemoryStream* ms,int n,byte* ar){
	for(int i=0;i<n;i++){
		char ch=0;
		ms->Write(&ch,1);
		ms->Write(ar+i*16,16);
	}
}*/
//---------------------------------------------------------------------------
void TSMC::encodetile32(TMemoryStream* ms,int n,byte* ar){
	for(int i=0;i<n;i++){
		char ch=0;
		ms->Write(&ch,1);
		ms->Write(ar+i*16,32);
	}
}
//---------------------------------------------------------------------------
void TSMC::saveenv(){
	int ix=level_type;
	if(gr_edited[0]) encodeenv(ms_data[ix*4+1],&bgblock,&bgtile,3,8,16,0x100,0x200,8,9,bg_rest);
	if(gr_edited[1]) encodeenv(ms_data[ix*4+2],&fgblock,&fgtile,6,8,32,0x100,0x100,8,8,fg_rest);
	if(gr_edited[2]) encodeenv(ms_data[ix*4+3],&ggblock,&ggtile,3,8,32,0x100,0x100,8,8,gg_rest);
	memset(gr_edited,0,sizeof(gr_edited));
}
//---------------------------------------------------------------------------
int TSMC::get_block_flags(int index){
	return level.block_flags_back_anim[index]&3;
}

void TSMC::set_block_flags(int index,int value){
	level.block_flags_back_anim[index] = level.block_flags_back_anim[index]&~3 | value&3;
}
//---------------------------------------------------------------------------
int TSMC::get_back_anim(int index){
	return level.block_flags_back_anim[index]>>2;
}

void TSMC::set_back_anim(int index,int value){
	level.block_flags_back_anim[index] = level.block_flags_back_anim[index]&3 | value<<2;
}
//---------------------------------------------------------------------------
template < class elem_type, size_t size >
void swap/*_arrays*/ ( elem_type array1[size], elem_type array2[size] ) {
	for (size_t i=0; i<size; i++) {
		swap(array1[i], array2[i]);
	}
}

template < class elem_type >
void swap_values (elem_type & var, elem_type value1, elem_type value2) {
	if (var == value1){
		var = value2;
	} else if (var == value2) {
		var = value1;
	}
}
//---------------------------------------------------------------------------
void TSMC::swap_room_positions(int room1, int room2) {
	if (room1 == room2) return;
	// Outgoing room links
	//swap<byte [4]>(level.room_links[room1],level.room_links[room2]);
	swap/*_arrays*/<byte,4>(level.room_links[room1],level.room_links[room2]);
	// Ingoing room links
	for (int i=0; i<24; i++) {
		for (int j=0; j<4; j++) {
			/*if (level.room_links[i][j] == room1) {
				level.room_links[i][j] = room2;
			} else if (level.room_links[i][j] == room2) {
				level.room_links[i][j] = room1;
			}*/
			swap_values(level.room_links[i][j], (byte)room1, (byte)room2);
		}
	}
}

void TSMC::swap_room_details(int room1, int room2) {
	if (room1 == room2) return;
	// Tiles
	swap/*_arrays*/<byte,30>(*(byte(*)[30])&level.background[room1],*(byte(*)[30])&level.background[room2]);
	swap/*_arrays*/<byte,30>(*(byte(*)[30])&level.foreground[room1],*(byte(*)[30])&level.foreground[room2]);
	swap/*_arrays*/<byte,30>(*(byte(*)[30])&level.modifiers[room1],*(byte(*)[30])&level.modifiers[room2]);
	// Guards
	swap(level.guard_tilepos[room1],level.guard_tilepos[room2]);
	swap(level.guard_sk[room1],level.guard_sk[room2]);
	swap(level.guard_type_dir[room1],level.guard_type_dir[room2]);
	swap(level.guard_uk1[room1],level.guard_uk1[room2]);
	swap(level.guard_uk2[room1],level.guard_uk2[room2]);
	swap(level.guard_uk3[room1],level.guard_uk3[room2]);
	// Start room
	swap_values(level.start_room, (byte)room1, (byte)room2);
	// Door links
	for (int index=0; index<256; index++) {
		int room, tilepos; bool next;
		get_door_event(index, room, tilepos, next);
		int old_room = room;
		swap_values(room, room1, room2);
		if (room != old_room) {
			set_door_event(index, room, tilepos, next);
		}
	}
}

void TSMC::swap_room_transparent(int room1, int room2) {
	if (room1 == room2) return;
	swap_room_positions(room1,room2);
	swap_room_details(room1,room2);
}
//---------------------------------------------------------------------------
/*
Format of door events:
-------------------------  7  6  5  4  3  2  1  0 <-bits
byte from door events 1 | NX R1 R0 L4 L3 L2 L1 L0
byte from door events 2 | R4 R3 R2  0  0  0  0  0
*/
void TSMC::get_door_event(int index, int& room, int& tilepos, bool& next) {
	byte ch1 = level.door_events_1[index];
	byte ch2 = level.door_events_2[index];
	room = (ch1&0x60)>>5 | (ch2&0xE0)>>3;
	tilepos = ch1&0x1F;
	next = ch1>>7;
}

void TSMC::set_door_event(int index, int room, int tilepos, bool next) {
	byte ch1 = tilepos&0x1F | (room&3)<<5 | next<<7;
	byte ch2 = (room&0x1C)<<3;
	level.door_events_1[index] = ch1;
	level.door_events_2[index] = ch2;
}
//---------------------------------------------------------------------------

#pragma package(smart_init)
