//---------------------------------------------------------------------------

#ifndef smcH
#define smcH
//---------------------------------------------------------------------------
#include <classes.hpp> // TMemoryStream
#include <graphics.hpp> // TColor
#include <vector>

#define COUNT(a) (sizeof(a)/sizeof((a)[0]))

typedef unsigned __int8 byte;
typedef unsigned __int16 word;

#pragma pack(push,1) // byte align
typedef struct{
	byte background[24][3][10];
	byte foreground[24][3][10];
	byte modifiers[24][3][10];
	byte block_gg[256];
	byte block_fg[256];
	byte block_object[256];
	byte block_flags_back_anim[256]; // bottom 3 bits: block flags, top 6 bits: background animation group
	byte room_links[24][4];
	byte start_room,start_tilepos,start_dir,zero;
	byte guard_tilepos[24];
	byte guard_type_dir[24]; // bottom 7 bits: type, top 1 bit: direction
	byte guard_sk[24]; // unused (skill)
	byte guard_uk1[24]; // xpos (only in RAM)
	byte guard_uk2[24]; // sequence pointer low (only in RAM)
	byte guard_uk3[24]; // sequence pointer high (only in RAM)
	byte door_events_1[256];
	byte door_events_2[256];
}TLevel;
#if sizeof(TLevel)!=3940
#error Level size is incorrect!
#endif

// For copy/paste
typedef struct{
	byte background[3][10];
	byte foreground[3][10];
	byte modifiers[3][10];
	//byte room_links[4];
	byte guard_tilepos;
	byte guard_type_dir;
	byte guard_sk;
	byte guard_uk1;
	byte guard_uk2;
	byte guard_uk3;
}TRoom;
#pragma pack(pop)

class TSMC {
private:
	TMemoryStream* ms_smc;
	TMemoryStream** ms_data; int ndata;
	int SMCHD;
	bool gr_edited[3];
	TMemoryStream* bg_rest;
	TMemoryStream* fg_rest;
	TMemoryStream* gg_rest;
	//Graphics::TBitmap* bm_torch;
	
	void decode_environment_layer(TMemoryStream* ms_in, word*&block, byte*&tile,
		int block_width, int block_height, int tile_size, int n_blocks, int n_tiles, int Bib, int Bit, TMemoryStream*&rest);
	//void decodetile16(TMemoryStream*,int,byte*);
	//void decodetile32(TMemoryStream*,int,byte*);
	//void decode_mapping(TMemoryStream*,int,int,word*);
	//void decodeblock(TMemoryStream* ms,int n,int si,word* ar,bool big);
	//void decompress_level_part(TMemoryStream*,TMemoryStream*,int);
	void open_level_graphics(int level_type);
public:
	int curr_level;
	int curr_room;
	int level_type;
	int object_level_type;
	bool show_labels;
	word* bgblock;
	byte* bgtile;
	word* fgblock;
	byte* fgtile;
	word* ggblock;
	byte* ggtile;
	TColor* pal,*selected_pal;
	bool sel[3][10];
	TLevel level;
	TSMC();
	~TSMC();
	bool opensmc(AnsiString filename);
	void clear();
	void openlevel(int new_level);
	void drawroom(Graphics::TBitmap*);
	void draw_floor_wall(Graphics::TBitmap* dest_bitmap, int x0, int y0, int flags);
	void drawlayer(Graphics::TBitmap*,byte[3][10],int,int,int,word*,byte*,byte*,byte,byte*);
	void drawblock(Graphics::TBitmap*,int,int,int,int,int,int,word*,byte*,byte,bool);
	void drawtile(Graphics::TBitmap*,int,int,int,int,byte*,byte,bool);
	//void decode_palette(TMemoryStream*,TColor*&,int);
//	void create_selected_palette(TColor*,TColor*/***/,int);
	void clear_selection();
	void savelevel();
	void savesmc(AnsiString filename);
	//void compress_level_part(TMemoryStream*,TMemoryStream*,int);
//	unsigned __int32 lastsa;
	//void decodesprite(TMemoryStream* ms_in, byte*& tiles, byte& width_block, byte& height_block, byte& width_pixel, byte& height_pixel);
	void drawsprite(Graphics::TBitmap* dest_bitmap, int x0, int y0, int sprite_index, int palette_index, bool flip, bool selected);
	//void decode_background_sprite(TMemoryStream* ms_in, byte*& tiles);
	void draw_background_sprite(Graphics::TBitmap* bm,int x0,int y0,int ix,bool sel);
	void draw_object(Graphics::TBitmap* bm,int x0,int y0,byte ch,bool sel);
	void drawtorch(Graphics::TBitmap* bm,int x0,int y0,bool sel);
	void close_level_graphics();
	void* ROM_pointer(int addr);
	void set_level_type(int level_number, int level_type);
	void editenvpal();
	void editpal(int index, AnsiString title, const char** descriptions);
	//void encode_palette(TMemoryStream*,TColor*,int);
	void editspritespal();
	void editscrnpal();
	void edithcpal();
	void editlevelgr(int layer);

	void encodeenv(TMemoryStream* ms_out,word**block,byte**tile,int wh,int hh,int si,int nb,int nt,int Bib,int Bit,TMemoryStream* rest);
	void encodeblocks(TMemoryStream*,int,int,word*,bool big);
	void encodeblock(TMemoryStream*,int,word*,bool big);
	void encodetile16(TMemoryStream*,int,byte*);
	void encodetile32(TMemoryStream*,int,byte*);
	void saveenv();
	void determine_array(int n,int si,char* items,TMemoryStream*& ms_new_items,std::vector<word> & out_mapping,int bits);

	int get_block_flags(int index);
	void set_block_flags(int index, int value);
	int get_back_anim(int index);
	void set_back_anim(int index, int value);
	void get_door_event(int index, int& room, int& tilepos, bool& next);
	void set_door_event(int index, int room, int tilepos, bool next);

	void swap_room_positions(int room1, int room2);
	void swap_room_details(int room1, int room2);
	void swap_room_transparent(int room1, int room2);
	bool show_floors_walls;
};
extern const char* object_names[0x2C];
extern const char* guard_names[0x19];
extern const char* level_names[0x1B];
extern const char* level_type_names[10];

#endif

