#!/usr/bin/env python

import struct
import sys
import pygame

LINK_LEFT = 0
LINK_RIGHT = 1
LINK_UP = 2
LINK_DOWN = 3

class Dat:
	def __init__(self):
		self.fd = None
		self.IndexOffset = None
		self.IndexSize = None

		self.NbItems = None
		#self.Index = None

		self.items = []
	
	def __del__(self):
		if self.fd != None:
			self.fd.close()
			self.fd = None

	def load(self, file):
		self.fd = open(file, 'r+b')
		self.IndexOffset = struct.unpack('<I', self.fd.read(4))[0]
		self.IndexSize = struct.unpack('<H', self.fd.read(2))[0]

		self.fd.seek(self.IndexOffset)

		self.NbItems = struct.unpack('<H', self.fd.read(2))[0]
		
		for i in range(self.NbItems):
			self.items.append(Item())
			self.items[i].ID = struct.unpack('<H', self.fd.read(2))[0]
			self.items[i].ressourceOffset = struct.unpack('<I', self.fd.read(4))[0]
			self.items[i].size = struct.unpack('<H', self.fd.read(2))[0]

	def write_levels(self, levels):
		for i in range(self.NbItems):
			self.fd.seek(1 + self.items[i].ressourceOffset)
			for j in levels[i].wall:
				self.fd.write(struct.pack('B', j))
			for j in levels[i].bg:
				self.fd.write(struct.pack('B', j))
			for j in levels[i].doors1:
				self.fd.write(struct.pack('B', j))
			for j in levels[i].doors2:
				self.fd.write(struct.pack('B', j))
			for j in levels[i].links:
				for k in j:
					self.fd.write( (struct.pack('B', k)))
			self.fd.write(levels[i].UnknownI )
			self.fd.write(struct.pack('3B', levels[i].startpos[0], levels[i].startpos[1], levels[i].startpos[2]))
			self.fd.write(levels[i].UnknownII)
			self.fd.write(levels[i].UnknownIII)
			for j in levels[i].guardpos:
				self.fd.write(struct.pack('B', j))
			for j in levels[i].guarddir:
				self.fd.write(struct.pack('B',j))
			self.fd.write(levels[i].UnknownIVa)
			self.fd.write(levels[i].UnknownIVb)
			for j in levels[i].guardskill:
				self.fd.write(struct.pack('B', j))
			self.fd.write(levels[i].UnknownIVc)
			for j in levels[i].guardcolor:
				self.fd.write(struct.pack('B', j))
			self.fd.write(levels[i].UnknownIVd)
			self.fd.write(levels[i].end) 

			self.fd.seek(1 + self.items[i].ressourceOffset)
			checksum = 0xFF - (sum(struct.unpack(str(self.items[i].size) + 'B', self.fd.read(self.items[i].size))) & 0xFF)
			self.fd.seek(self.items[i].ressourceOffset)
			self.fd.write(struct.pack('B', checksum))
			


	def read_levels(self):
		levels = []
		for i in range(self.NbItems):
			self.fd.seek(1 + self.items[i].ressourceOffset)

			levels.append(Level())
			levels[i].wall = list(struct.unpack('720B', self.fd.read(720)))
			levels[i].bg = list(struct.unpack('720B', self.fd.read(720)))
			levels[i].doors1 = list(struct.unpack('256B', self.fd.read(256)))
			levels[i].doors2 = list(struct.unpack('256B', self.fd.read(256)))
			for j in range(24):
				levels[i].links.append(list(struct.unpack('4B', self.fd.read(4))))
			levels[i].UnknownI = self.fd.read(64)
			levels[i].startpos = list(struct.unpack('3B', self.fd.read(3)))
			levels[i].UnknownII = self.fd.read(3)
			levels[i].UnknownIII = self.fd.read(1)
			levels[i].guardpos = list(struct.unpack('24B', self.fd.read(24)))
			levels[i].guarddir = list(struct.unpack('24B', self.fd.read(24)))
			levels[i].UnknownIVa = self.fd.read(24)
			levels[i].UnknownIVb = self.fd.read(24)
			levels[i].guardskill = list(struct.unpack('24B', self.fd.read(24)))
			levels[i].UnknownIVc = self.fd.read(24)
			levels[i].guardcolor = list(struct.unpack('24B', self.fd.read(24)))
			levels[i].UnknownIVd = self.fd.read(16)
			if i == 15:
				levels[i].end = self.fd.read(1)
			else:
				levels[i].end = self.fd.read(2)
		return levels
			
		

class Item:
	def __init__(self):
		self.ID = None
		self.ressourceOffset = None
		self.size = None

class Level:
	def __init__(self):
		self.wall = None
		self.bg = None
		self.doors1 = None
		self.doors2 = None
		self.links = []
		self.UnknownI = None
		self.startpos = None
		self.UnknownII = None
		self.UnknownIII = None
		self.guardpos = []
		self.guarddir = []
		self.UnknownIVa = None
		self.UnknownIVb = None
		self.guardskill = []
		self.UnknownIVc = None
		self.guardcolor = []
		self.UnknownIVd = None
		self.end = None

level_file = "LEVELS.DAT"


datfile = Dat()
datfile.load(level_file)

levels = datfile.read_levels()

levels[ 5].links[21][LINK_LEFT ] = 19
levels[11].links[ 1][LINK_LEFT ] = 20
levels[11].links[13][LINK_DOWN ] = 11
levels[10].links[ 1][LINK_DOWN ] = 23
levels[10].links[14][LINK_DOWN ] = 23
levels[ 6].links[23][LINK_LEFT ] = 16
levels[ 2].links[ 5][LINK_LEFT ] = 17
levels[ 4].links[20][LINK_LEFT ] = 17
levels[ 5].links[ 5][LINK_LEFT ] = 14
levels[ 6].links[ 5][LINK_LEFT ] = 14
levels[11].links[ 4][LINK_LEFT ] = 21

levels[11].links[ 5][LINK_UP   ] =  8

datfile.write_levels(levels)

